/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.base;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangmj
 * @version EasyPayMerchantBizRequest.java, v 0.1 2023-11-02 20:54 zhangmj
 */
@Data
public class EasyPayMerchantBizResponse<T> implements Serializable {
    private static final long serialVersionUID = 6114059779138715451L;

    /**
     * 机构号
     */
    private String clientCode;

    /**
     * MAC值 签名 32位
     */
    private String MAC;

    /**
     * 版本号
     * 默认1.0
     */
    private String version = "1.0";

    /**
     * 返回码
     */
    private String retCode;

    /**
     * 错误描述
     */
    private String retMsg;

    /**
     * 业务数据
     */
    private T data;
}