/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.rate;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhubo
 * @version AlipayRate.java, v 0.1 2023-11-08 15:36 zhubo
 */
@Data
public class AlipayRate implements Serializable {
    private static final long serialVersionUID = -7581783067989842705L;

    /**
     * 微信：功能ID：2
     * 支付宝：功能ID:3
     * 银联二维码:功能ID：12
     * 银联营销业务:功能ID：14
     */
    private Integer funcId;
    /**
     * 扣率（单位：%）
     */

    @Length(max = 50, message = "calcVal扣率长度不能超过50")
    private String calcVal;

    /**
     * 不需自动拆分 送：ZWOSZ1111111111
     */
    @Length(max = 50, message = "brandName不需自动拆分长度不能超过50")
    private String brandName;
    /**
     * 微信：空
     * 支付宝：支付宝PID
     */
    @Length(max = 50, message = "appid支付宝PID长度不能超过50")
    private String appid;
    /**
     * 微信：空
     * 支付宝：支付宝子商户号
     */
    @Length(max = 100, message = "alipayId支付宝子商户号长度不能超过100")
    private String alipayId;

    /**
     * 微信：空
     * 支付宝：支付宝认证URL
     */
    @Length(max = 200, message = "alipayCertUrl支付宝认证URL长度不能超过200")
    private String alipayCertUrl;

    /**
     * 开通状态：0-未开通；1-已开通；X-失败；3-处理中；9-商户已注销
     */
    @Length(max = 1, message = "state开通状态长度不能超过1")
    private String state;
    /**
     * 错误描述
     */
    @Length(max = 200, message = "retMsg错误描述长度不能超过200")
    private String retMsg;
}
