/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author zhubo
 * @version PictureInfo.java, v 0.1 2023-11-04 11:26 zhubo
 */
@Data
public class PictureInfo implements Serializable {
    private static final long serialVersionUID = -3671682753711028976L;

    @NotBlank
    @Length(max = 2, message = "picMode图片类型长度不能超过2")
    private String picMode;

    @NotBlank
    @Length(max = 2, message = "fileId图片唯一ID长度不能超过30")
    private String fileId;
}
