/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * @author zhubo
 * @version AccInfoBak.java, v 0.1 2023-11-04 11:15 zhubo
 */
@Data
public class AccInfoBak implements Serializable {
    private static final long serialVersionUID = 9157326622998016753L;

    /**
     * 银行名称:开户行名称--传对私结算账户的开户行名称
     */
    @Length(max = 100, message = "bankName银行名称长度不能超过100")
    private String bankName;
    /**
     * 开户行行号--传对私结算账户的开户行名称
     */
    @Length(max = 20, message = "bankCode开户行行号长度不能超过20")
    private String bankCode;
    /**
     * 账号--传对私结算账户
     */
    @Length(max = 32, message = "account账号长度不能超过32")
    private String account;
    /**
     * 账户名称--传对私结算账户名称
     */
    @Length(max = 100, message = "accName账户名称长度不能超过100")
    private String accName;
    /**
     * 账户类型：10-对公
     */
    @Length(max = 2, message = "accType账户类型长度不能超过2")
    private String accType;
}
