/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.base;

import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.base.EasyPayMerchantBizResponse;
import lombok.Data;

import java.io.Serializable;

/**
 * @author zhubo
 * @version EasyPayMerchantBaseRequest.java, v 0.1 2023-11-08 19:29 zhubo
 */
@Data
public class EasyPayMerchantBaseRequest<R extends EasyPayMerchantBizResponse> extends EasyPayBizRequest<R> implements Serializable {
    private static final long serialVersionUID = -8743296996580767613L;

    private String version;

    private String messageType;

    private String clientCode;

    private String MAC;

    @Override
    public Class<R> getResponseClass() {
        return null;
    }
}
