/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import lombok.Data;

import java.io.Serializable;

/**
 * @author zhangmj
 * @version SysInfo.java, v 0.1 2023-11-02 21:14 zhangmj
 */
@Data
public class SysInfo implements Serializable {

    private static final long serialVersionUID = -5004370826950490509L;

    /**
     * 终端种类 不可变更
     **/
    private String termMode;
    /**
     * 内部商户号 不可变更
     **/
    private String merCode;
    /**
     * 内部终端号 不可变更
     **/
    private String termCode;
    /**
     * 终端名称 可变更
     **/
    private String username;
    /**
     * 区号 可变更
     **/
    private String areaNo;
    /**
     * 电话号码 可变更
     **/
    private String terminalno;
    /**
     * 终端地区 可变更
     **/
    private String termArea;
    /**
     * 终端布放地址 可变更
     **/
    private String installaddress;
    /**
     * 联系人 可变更
     **/
    private String linkMan;
    /**
     * 联系电话 可变更
     **/
    private String linkPhone;
    /**
     * 所属商圈 可变更
     **/
    private String businessZone;
    /**
     * 设备型号 可变更
     **/
    private String termModel;
    /**
     * 机具号 可变更
     **/
    private String termModelLic;
    /**
     * 终端商户号 (接口发起交易使用)  不可变更
     **/
    private String termMercode;
    /**
     * 终端终端号 (接口发起交易使用)  不可变更
     **/
    private String termTermcode;
    /**
     * 渠道商户号：终端类型为4或者5时，必须上送该字段  不可变更
     **/
    private String bangdingcommercode;
    /**
     * 渠道终端号：终端类型为4或者5时，必须上送该字段  不可变更
     **/
    private String bangdingtermno;
    /**
     * 无线终端SIM卡 可变更
     **/
    private String simno;
    /**
     * 备注 可变更
     **/
    private String remark;
    /**
     * 虚拟终端号 可变更
     **/
    private String termCretCode;
}