/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant.info;

import com.fshows.easypay.sdk.response.merchant.rate.AlipayRate;
import com.fshows.easypay.sdk.response.merchant.rate.UnionRate;
import com.fshows.easypay.sdk.response.merchant.rate.WxRate;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 功能信息
 * @author zhangmj
 * @version FuncInfo.java, v 0.1 2023-11-02 21:25 zhangmj
 */
@Data
public class FuncInfo implements Serializable {

    private static final long serialVersionUID = 910365241127083159L;

    /**
     * 微信费率
     */
    private WxRate wxRate;

    /**
     * 支付宝费率
     */
    private AlipayRate alipayRate;

    /**
     * 银联<=1000费率
     */
    private UnionRate unionRate;

    /**
     * 银联>1000费率
     */
    private UnionRate unionRate2;
}