/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.response.merchant;

import com.fshows.easypay.sdk.response.base.EasyPayMerchantBizResponse;
import com.fshows.easypay.sdk.response.merchant.info.AccInfo;
import com.fshows.easypay.sdk.response.merchant.info.CustomInfo;
import com.fshows.easypay.sdk.response.merchant.info.FuncInfo;
import com.fshows.easypay.sdk.response.merchant.info.LicInfo;
import com.fshows.easypay.sdk.response.merchant.info.MerchantInfo;
import com.fshows.easypay.sdk.response.merchant.info.PlusInfo;
import com.fshows.easypay.sdk.response.merchant.info.SysInfo;
import lombok.Data;

/**
 * @author zhangmj
 * @version EasyPayMerchantInfoQueryResponse.java, v 0.1 2023-11-01 15:49 zhangmj
 */
@Data
public class MerchantInfoQueryResponse extends EasyPayMerchantBizResponse {
    private static final long serialVersionUID = -188263878977277045L;

    /**
     * 商户信息
     */
    private MerchantInfo merInfo;

    /**
     * 附加信息
     */
    private PlusInfo plusInfo;

    /**
     * 终端信息
     */
    private SysInfo sysInfo;

    /**
     * 营业执照信息
     */
    private LicInfo licInfo;

    /**
     * 结算账户信息
     */
    private AccInfo accInfo;

    /**
     * 功能信息
     */
    private FuncInfo funcInfo;

    /**
     * 自定义域
     */
    private CustomInfo customInfo;
}