/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.easypay.sdk.request.merchant;

import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantAuditQueryResponse;
import lombok.Data;

/**
 * @author zhubo
 * @version MerchatnAuditQueryRequest.java, v 0.1 2023-11-04 14:42 zhubo
 */
@Data
public class MerchantAuditQueryRequest extends EasyPayBizRequest<MerchantAuditQueryResponse> {
    private static final long serialVersionUID = 7135489647895917056L;

    /**
     * 商户唯一标识
     */
    private String merTrace;

    /**
     * 原操作流水号，最长20字符
     */
    private String operaTrace;

    @Override
    public Class<MerchantAuditQueryResponse> getResponseClass() {
        return MerchantAuditQueryResponse.class;
    }
}
