package com.fshows.easypay.sdk.enums;

import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.request.config.EasyPayWeChatAppIdConfigRequest;
import com.fshows.easypay.sdk.request.config.EasyPayWeChatDirectoryConfigRequest;
import com.fshows.easypay.sdk.request.merchant.MerchantInfoQueryRequest;
import com.fshows.easypay.sdk.response.merchant.MerchantInfoQueryResponse;
import com.fshows.easypay.sdk.response.merchant.WechatAppIdConfigResponse;
import com.fshows.easypay.sdk.response.merchant.WechatJsApiConfigResponse;
import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * @author zhaoxumin
 * @version EasyPayBaseClient.java, v 0.1 2023-10-27 13:38
 */
@Getter
public enum EasyMerchantApiEnum implements EasyPayApiDefinition {

    MERCHANT_INFO_QUERY(
            "商户信息查询",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            MerchantInfoQueryRequest.class,
            MerchantInfoQueryResponse.class
    ),
    WECHAT_APPID_CONFIG(
            "微信APPID配置",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            EasyPayWeChatAppIdConfigRequest.class,
            WechatAppIdConfigResponse.class
    ),
    WECHAT_DIRECT_CONFIG(
            "微信授权目录配置",
            "/AG_MerchantManagementSystem_Core/agent/api/gen",
            EasyPayWeChatDirectoryConfigRequest.class,
            WechatJsApiConfigResponse.class
    ),

    ;

    /**
     * 接口名称
     */
    private final String name;
    /**
     * 接口
     */
    private final String value;
    /**
     * 请求参数类型
     */
    private final Class requestClass;
    /**
     * 响应参数类型
     */
    private final Class responseClass;

    EasyMerchantApiEnum(String name, String value, Class requestClass, Class responseClass) {
        this.name = name;
        this.value = value;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    public static EasyMerchantApiEnum getByValue(String value) {
        EasyMerchantApiEnum[] valueList = EasyMerchantApiEnum.values();
        for (EasyMerchantApiEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getMethod(), value)) {
                return v;
            }
        }
        return null;
    }

    @Override
    public String getMethod() {
        return value;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }

    public static void main(String[] args) {
        System.out.println(1);
    }
}