/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.easypay.sdk.client.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.easypay.sdk.client.EasyPayMerchantClient;
import com.fshows.easypay.sdk.client.impl.EasyPayApiDefinition;
import com.fshows.easypay.sdk.enums.EasyMerchantApiEnum;
import com.fshows.easypay.sdk.exception.EasyPayException;
import com.fshows.easypay.sdk.request.EasyPayBizRequest;
import com.fshows.easypay.sdk.response.base.EasyPayMerchantBizResponse;
import com.fshows.easypay.sdk.util.FsHttpUtil;
import com.fshows.easypay.sdk.util.SignUtil;
import com.fshows.easypay.sdk.util.ValidateUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyPayMerchantClientImpl
implements EasyPayMerchantClient {
    private static final Logger log = LoggerFactory.getLogger(EasyPayMerchantClientImpl.class);
    private final String appId;
    private final String signType;
    private final String key;
    protected int connectionTimeout = 5000;
    protected int readTimeout = 5000;
    private static final SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public EasyPayMerchantClientImpl(String appId, String signType, String key) {
        this.appId = appId;
        this.signType = signType;
        this.key = key;
    }

    @Override
    public <R, T> EasyPayMerchantBizResponse<T> execute(EasyPayBizRequest<R> request, EasyPayApiDefinition easyPayApiDefinition, String url) throws EasyPayException {
        return this.execute(request, easyPayApiDefinition, url, this.appId);
    }

    @Override
    public <R, T> EasyPayMerchantBizResponse<T> execute(EasyPayBizRequest<R> request, EasyPayApiDefinition definition, String postUrl, String subAppId) throws EasyPayException {
        String method = definition.getMethod();
        this.validateParam(request, method);
        long startTime = System.currentTimeMillis();
        String url = postUrl + method;
        try {
            Map<String, String> requestData = this.getRequestData(request, (String)StringUtils.defaultIfBlank((CharSequence)subAppId, (CharSequence)this.appId));
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5f00\u59cb >> url={}, request={}", (Object)url, requestData);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Accept", "application/json");
            String easyPayResponse = FsHttpUtil.post(url, requestData, "utf-8", "application/x-www-form-urlencoded", this.connectionTimeout, this.readTimeout, headers);
            log.info("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u7ed3\u675f >> url={}, request={},response={},cost={}", new Object[]{url, requestData, easyPayResponse, System.currentTimeMillis() - startTime});
            return this.parseResponse(easyPayResponse, request);
        }
        catch (Exception ex) {
            log.error("\u3010easypay-sdk\u3011\u63a5\u53e3\u8c03\u7528\u5931\u8d25 >> url={}, request={},ex={},cost={}", new Object[]{url, request, ExceptionUtils.getStackTrace((Throwable)ex), System.currentTimeMillis() - startTime});
            throw new EasyPayException(ex.getMessage());
        }
    }

    private <R, T> EasyPayMerchantBizResponse<T> parseResponse(String result, EasyPayBizRequest<R> request) {
        EasyPayMerchantBizResponse bizResponse = (EasyPayMerchantBizResponse)JSON.parseObject((String)result, EasyPayMerchantBizResponse.class);
        bizResponse.setData(JSON.parseObject((String)result, request.getResponseClass()));
        return bizResponse;
    }

    private <R> Map<String, String> getRequestData(EasyPayBizRequest<R> request, String appId) throws EasyPayException {
        TreeMap<String, String> parameterMap = SignUtil.getSignParameterMap(request);
        parameterMap.put("clientCode", appId);
        parameterMap.put("version", "1.0");
        String sign = SignUtil.generateMd5Sign(parameterMap, this.key);
        parameterMap.put("MAC", sign);
        return parameterMap;
    }

    private <R> void validateParam(EasyPayBizRequest<R> request, String method) {
        if (request == null) {
            throw new IllegalArgumentException("\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.key)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)this.signType)) {
            throw new IllegalArgumentException("\u7b7e\u540d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == EasyMerchantApiEnum.getByValue(method)) {
            throw new IllegalArgumentException("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u5b58\u5728");
        }
        ValidateUtil.validateWithThrow(request, new Class[0]);
    }

    static {
        EasyPayMerchantClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

