/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 订单查询 response
 *
 * @author
 * @version CmbcPaymentResultSelectNewResponse.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcPaymentResultSelectNewResponse extends CmbcBizResponse {
    private static final long serialVersionUID = 5556413666987038284L;

    /**
     * 回显商户名
     * 商户用于回显商户收款的名字
     */
    private String merchantName;

    /**
     * 商户订单号
     * 原交易商户订单号
     */
    private String merchantSeq;

    /**
     * 交易金额. 单位分
     */
    private String amount;

    /**
     * 订单详情. 传入商品信息等
     */
    private String orderInfo;

    /**
     * 凭证号
     * 收单凭证号
     */
    private String voucherNo;

    /**
     * 银行流水号
     * 收单系统流水号
     */
    private String bankTradeNo;

    /**
     * 订单交易结果
     * S 订单交易成功 
     * E 订单失败 
     * R 原订单成功，未支付（待支付) 
     * C 已撤销（理论上不存在） 已关闭
     * T 订单转入退款
     */
    private String tradeStatus;

    /**
     * 保留域
     * 所查询订单的状态
     */
    private String remark;

    /**
     * 参考号
     */
    private String refNo;

    /**
     * 批次号
     */
    private String batchNo;

    /**
     * 卡类型
     * 0 借记卡 
     * 1 贷记卡
     */
    private String cardType;

    /**
     * 卡号. 前六后四中间*
     */
    private String cardNo;

    /**
     * 发卡行行号
     */
    private String cbCode;

    /**
     * 发卡行行名
     */
    private String cardName;

    /**
     * 交易手续费
     */
    private String fee;

    /**
     * 消费类型： 
     * 1. 微信正扫 
     * 2. 微信反扫 
     * 3. 刷卡 
     * 4. 微信二维码收银台支付、微信扫银联二维码 
     * 5. 支付宝正扫 
     * 6. 支付宝反扫 
     * 7. 支付宝二维码收银台支付、支付宝扫银联二维码 
     * 17. 二维码收银台-民生付模式 
     * 23. 直销一码通支付（反扫）
     */
    private String tradeType;

    /**
     * 银联终端号
     */
    private String cupTermId;

    /**
     * 设备序列号
     */
    private String cupTsamNo;

    /**
     * 其他信息
     */
    private String centerInfo;

    /**
     * 微信订单号
     */
    private String centerSeqId;

    /**
     * 收单到微信下单编号
     */
    private String bankOrderNo;

    /**
     * 服务商附加信息
     */
    private String corpReserve;

    /**
     * 营销信息
     * 支付时未使用权益，redInfo 返回为空； 若有权益返回 json 格式
     */
    private String redInfo;

    /**
     * 交易日期. 格式yyyyMMdd
     */
    private String tranDate;

    /**
     * 交易时间. 格式HHMMSS
     */
    private String tranTime;

    /**
     * 实付金额. 单位分
     * 查询下单返回的是实付金额，查询退款返回的是实退金额
     */
    private String actualPayAmt;

    /**
     * 数币支付完成时间，格式：YYYYMMDDHHMMSS
     */
    private String payedDatetime;
}