/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 账单下载 response
 *
 * @author
 * @version CmbcFileDownloadResponse.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcFileDownloadResponse extends CmbcBizResponse {
    private static final long serialVersionUID = 2517770780741643506L;

    /**
     * 接入平台号
     * 民生银行为接入平台分配的平台编号
     */
    private String platformId;

    /**
     * 交易明细单日期. 格式yyyyMMdd
     */
    private String slcTransDate;

    /**
     * 块文件索引
     * 参考请求字段，表示当前请求的第几块文件
     */
    private Integer segmentIndex;

    /**
     * 文件类型. 参考请求字段
     */
    private String fileType;

    /**
     * 块大小
     * 参考请求字段，单位为KB，最大1024KB
     */
    private Integer segmentSize;

    /**
     * 当前分块内容
     * 当前块内容（Base64 加密的 String 字符串），最大为 1M，单位为KB，例如：2KB，1024KB
     */
    private String segmentContent;

    /**
     * 当前块 MD5
     * 当前块的 MD5 值
     */
    private String segmentMd5;

    /**
     * 总块数
     * 总块数，表示文件的总块数
     */
    private Integer segmentCount;

    /**
     * 完整文件 MD5
     * 完整文件的 MD5 值
     */
    private String fileMd5;

    /**
     * 备注字段
     * 用于备注信息
     */
    private String reserve;
}