/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.response;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;


/**
 * @author
 * @version CmbcBizResponse.java, v 0.1 2025-02-10 15:37:48
 */
@Data
public class CmbcBaseResponse implements IResponseDefinition {
    private static final long serialVersionUID = -7643691879529232659L;

    /**
     * 商户流水
     * 原样返回
     */
    private String merchantSeq;

    /**
     * 交易编码
     * 原样返回
     */
    private String transCode;

    /**
     * 网关响应流水
     * 网关的响应流水，用于定位问题等
     */
    private String gateSeq;

    /**
     * 网关响应日期. 格式yyyyMMdd
     */
    private String gateTransDate;

    /**
     * 网关响应时间. 格式yyyyMMddHHmmssSSS
     */
    private String gateTransTime;

    /**
     * 网关响应结果
     * S:成功，E:失败，R:待查
     */
    private String gateReturnType;

    /**
     * 网关响应错误码
     * 错误码
     */
    private String gateReturnCode;

    /**
     * 网关响应错误信息
     * 错误信息
     */
    private String gateReturnMessage;

    /**
     * 备用字段 1
     * 一般备用字段
     */
    private String reserve1;

    /**
     * 备用字段 2
     * 一般备用字段
     */
    private String reserve2;

    /**
     * 备用字段 3
     * 一般备用字段
     */
    private String reserve3;

    /**
     * 通用备用字段
     * Json 格式的通用备用字段
     */
    private String reserveJson;

    /**
     * 业务报文
     * 仅当网关响应结果为成功时返回
     */
    private String businessContext;

    /**
     * 业务报文（解密）
     * 仅当网关响应结果为成功时返回
     */
    private IResponseDefinition decryptBusinessContext;
}