/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 账单下载 request
 *
 * @author
 * @version CmbcFileDownloadRequest.java, v 0.1 2025-02-10 15:37:48
 */
@Data
@ToString(callSuper = true)
public class CmbcFileDownloadRequest extends CmbcBizRequest {
    private static final long serialVersionUID = 4241993458190676749L;

    /**
     * 交易明细单日期
     * yyyyMMdd，交易明细单文件日期，目前支持当前自然日[T-1~T-8]7天内的交易明细单文件下载
     * (必填)
     */
    @NotBlank(message = "交易明细单日期不能为空")
    @Length(min = 8, max = 8, message = "交易明细单日期格式不正确，应为yyyyMMdd")
    private String slcTransDate;

    /**
     * 块文件索引
     * 0-N，当前请求第几块文件，如传0，则文件块内容和块MD5返空，其他信息齐全
     * (必填)
     */
    @NotBlank(message = "块文件索引不能为空")
    private String segmentIndex;

    /**
     * 文件类型
     * LSY 乐收银线下刷卡
     * WX 微信对账单
     * ZFB 支付宝对账单
     * QQ QQ钱包对账单
     * JDQB 京东对账单
     * BDQB 百度对账单
     * YLZF 银联对账单
     * ECNY 数字货币对账单
     * (必填)
     */
    @NotBlank(message = "文件类型不能为空")
    private String fileType;

    /**
     * 块大小
     * KB为单位，最大1024KB
     * (必填)
     */
    @NotBlank(message = "块大小不能为空")
    private String segmentSize;

    /**
     * 备注字段
     */
    private String reserve;
}