/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.request;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author
 * @version CmbcBizRequest.java, v 0.1 2025-02-10 15:37:48
 */
@Data
public class CmbcBizRequest implements IRequestDefinition {
    private static final long serialVersionUID = 6278818317671592038L;

    /**
     * 民生商户号
     * (必填)
     */
    @NotBlank(message = "商户号不能为空")
    @Length(max = 21, message = "商户号长度不能超过21")
    private String merchantNo;
}