/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author mengqf
 * @version CmbcBaseRequest.java, v 0.1 2025-02-10 11:20 mengqf
 */
@Data
public class CmbcBaseRequest implements Serializable {
    private static final long serialVersionUID = 7075573535240620229L;

    /**
     * 版本号
     * 用于版本控制、灰度发布、向下兼容等用途
     */
    private String version;

    /**
     * 发起来源
     * 发起渠道，用于标识 ios、Android、PC 等的渠道管控及版本控制
     * PC-PC Web 端；iOS-苹果客户端；Android-安卓客户端；
     */
    private String source;

    /**
     * 商户编号
     * 统一商户编号，由商户管理系统提供的统一商户编号
     */
    private String merchantNum;

    /**
     * 商户流水
     * 商户发起交易时使用的流水，互联网接入网关不对流水号去重，仅将商户编号和商户流水拼接后直接传递给后台系统
     */
    private String merchantSeq;

    /**
     * 交易日期. 格式yyyyMMdd
     */
    private String transDate;

    /**
     * 交易时间. 格式yyyyMMddHHmmssSSS
     */
    private String transTime;

    /**
     * 交易编码
     */
    private String transCode;

    /**
     * 安全类型
     * 决定使用何种证书、签名、加密算法
     */
    private String securityType;

    /**
     * 备用字段 1
     * 一般备用字段
     */
    private String reserve1;

    /**
     * 备用字段 2
     * 一般备用字段
     */
    private String reserve2;

    /**
     * 备用字段 3
     * 一般备用字段
     */
    private String reserve3;

    /**
     * 备用字段 4
     * 一般备用字段
     */
    private String reserve4;

    /**
     * 备用字段 5
     * 一般备用字段
     */
    private String reserve5;

    /**
     * 通用备用字段
     * Json 格式的通用备用字段
     */
    private String reserveJson;

    /**
     * 业务报文
     * 订单签名加密后的内容
     * (必填)
     */
    @NotBlank(message = "业务报文不能为空")
    private String businessContext;
}