package com.fshows.apienum;

import com.fshows.request.CmbcFileDownloadRequest;
import com.fshows.request.CmbcCustomsClearCancelRequest;
import com.fshows.request.CmbcPaymentResultSelectNewRequest;
import com.fshows.request.CmbcLcbpPayRequest;
import com.fshows.request.CmbcCancelTransRequest;
import com.fshows.response.CmbcFileDownloadResponse;
import com.fshows.response.CmbcCustomsClearCancelResponse;
import com.fshows.response.CmbcPaymentResultSelectNewResponse;
import com.fshows.response.CmbcLcbpPayResponse;
import com.fshows.response.CmbcCancelTransResponse;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;


/**
 * 民生银行交易相关API
 *
 * @author
 * @version CmbcTradeApiDefinitionEnum.java, v 0.1 2025-01-08 17:28
 */
public enum CmbcTradeApiDefinitionEnum implements IApiDefinition {

    LCBP_PAY(
            "统一下单",
            "/appserver/lcbpPay.do",
            "1.0.0",
            "TRADE",
            CmbcLcbpPayRequest.class,
            CmbcLcbpPayResponse.class
    ),
    PAYMENT_RESULT_SELECT_NEW(
            "支付结果查询（交易/退款）",
            "/appserver/paymentResultSelectNew.do",
            "1.0.0",
            "TRADE",
            CmbcPaymentResultSelectNewRequest.class,
            CmbcPaymentResultSelectNewResponse.class
    ),
    CANCEL_TRANS(
            "订单退款",
            "/appserver/cancelTrans.do",
            "1.0.0",
            "TRADE",
            CmbcCancelTransRequest.class,
            CmbcCancelTransResponse.class
    ),
    CUSTOMS_CLEAR_CANCEL(
            "撤关单",
            "/appserver/customsClearCancel.do",
            "1.0.0",
            "TRADE",
            CmbcCustomsClearCancelRequest.class,
            CmbcCustomsClearCancelResponse.class
    ),
    FILE_DOWNLOAD(
            "账单下载",
            "/fileDownload.do",
            "1.0.0",
            "TRADE",
            CmbcFileDownloadRequest.class,
            CmbcFileDownloadResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * 接口类型：
     * MERCHANT - 商户接口
     * TRADE  -  交易接口
     * COMMON  - 通用接口
     */
    private String interfaceType;


    CmbcTradeApiDefinitionEnum(String name,
                               String apiSubURI,
                               String version,
                               String interfaceType,
                               Class requestClass,
                               Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}