/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.client.impl;

import cn.hutool.core.util.StrUtil;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.CcbPayHttpResult;
import com.fshows.ccbpay.client.base.ICcbPayApiClient;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.client.impl.DefaultHttpRequestImpl;
import com.fshows.ccbpay.client.impl.DefaultSignerImpl;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.LogUtil;
import com.fshows.ccbpay.util.ValidateUtil;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCcbPayApiClientImpl
implements ICcbPayApiClient {
    private static final Logger log = LoggerFactory.getLogger(AbstractCcbPayApiClientImpl.class);
    protected ApiClientConfig apiClientConfig;
    protected IHttpRequest httpRequest;
    protected ISigner<CcbPayBaseRequest, CcbPayBaseResponse> signer;

    public AbstractCcbPayApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = new DefaultHttpRequestImpl();
        this.signer = new DefaultSignerImpl<CcbPayBaseRequest, CcbPayBaseResponse>();
    }

    public AbstractCcbPayApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
        this.httpRequest = httpRequest;
        this.signer = signer;
    }

    protected <R extends CcbPayBaseResponse, E extends ICcbPayApiDefinition> R doExecute(CcbPayBaseRequest<R, E> bizRequest, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException {
        try {
            boolean bo;
            this.checkParam(bizRequest, tradeApiDefinitionEnum);
            CcbPayBaseRequest ccbpayBaseRequest = this.buildBizRequest(bizRequest, tradeApiDefinitionEnum);
            String body = this.serializableRequest(ccbpayBaseRequest, tradeApiDefinitionEnum);
            String url = this.getServerURL(tradeApiDefinitionEnum);
            CcbPayHttpResult httpResult = this.requestPost(url, null, body);
            CcbPayBaseResponse response = this.parseResponse(httpResult.getBody(), tradeApiDefinitionEnum);
            if (StrUtil.isNotBlank((CharSequence)response.getErrCode())) {
                return (R)response;
            }
            if (this.apiClientConfig.isVrifySignResponse() && !(bo = this.signer.verifySign(response, this.apiClientConfig).booleanValue())) {
                LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> httpResult={}", httpResult);
                throw new CcbPayApiException("\u3010ccbpay-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25");
            }
            return (R)response;
        }
        catch (CcbPayApiException e) {
            LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u5efa\u884c\u5f00\u653e\u5e73\u53f0\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u5efa\u884c\u5f00\u653e\u5e73\u53f0\u8bf7\u6c42\u5f02\u5e38 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw new CcbPayApiException(e.getMessage(), e);
        }
    }

    protected CcbPayHttpResult requestPost(String url, String authorization, String requestBody) throws IOException, CcbPayApiException {
        long beginTime = System.currentTimeMillis();
        try {
            LogUtil.info(log, "\u3010ccbpay-sdk\u3011\u8bf7\u6c42\u5f00\u59cb >> url={}, authorization={}, request={}, begin={}", url, authorization, requestBody, beginTime);
            CcbPayHttpResult httpResult = this.httpRequest.post(url, authorization, requestBody, this.apiClientConfig);
            if (httpResult == null || StringUtils.isBlank((CharSequence)httpResult.getBody())) {
                throw new CcbPayApiException("ccbpay\u54cd\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            LogUtil.info(log, "\u3010ccbpay-sdk\u3011\u8bf7\u6c42\u7ed3\u675f >> url={}, request={}, response={}, cost={}ms", url, requestBody, httpResult.getBody(), System.currentTimeMillis() - beginTime);
            return httpResult;
        }
        catch (CcbPayApiException e) {
            LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u7f51\u7edc\u8bf7\u6c42\u5f02\u5e38 >> url={}, request={}, cost={}ms", e, url, requestBody, System.currentTimeMillis() - beginTime);
            throw new CcbPayApiException("\u8bf7\u6c42ccbpay\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    protected void checkParam(CcbPayBaseRequest bizRequest, ICcbPayApiDefinition apiDefinition) throws CcbPayApiException {
        ValidateUtil.notNull(bizRequest, "request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        System.out.println();
        boolean checkRequestClass = StringUtils.equals((CharSequence)bizRequest.getClass().getCanonicalName(), (CharSequence)apiDefinition.getRequestClass().getCanonicalName());
        if (!checkRequestClass) {
            throw new CcbPayApiException("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.apiClientConfig.isCheckParam()) {
            ValidateUtil.validateWithThrow(bizRequest, new Class[0]);
        }
    }

    protected String getServerURL(ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return this.apiClientConfig.getApiParentURL() + tradeApiDefinitionEnum.getApiSubURI();
    }

    protected abstract CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest var1, ICcbPayApiDefinition var2);

    protected abstract String serializableRequest(CcbPayBaseRequest var1, ICcbPayApiDefinition var2) throws CcbPayApiException, IOException;

    protected abstract CcbPayBaseResponse parseResponse(String var1, ICcbPayApiDefinition var2);

    public void setApiClientConfig(ApiClientConfig apiClientConfig) {
        this.apiClientConfig = apiClientConfig;
    }

    public void setHttpRequest(IHttpRequest httpRequest) {
        this.httpRequest = httpRequest;
    }

    public void setSigner(ISigner<CcbPayBaseRequest, CcbPayBaseResponse> signer) {
        this.signer = signer;
    }
}

