/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.response.wlpt;

import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wangqilei
 * @version CcbOrderRefundResponse.java, v 0.1 2024-04-26 3:54 PM wangqilei
 */
@Data
public class CcbRefundQueryResponse extends CcbPayBaseResponse {
    private static final long serialVersionUID = 4124014514945011364L;
    /**
     * 同请求报文中的序列号
     * (选填)
     */
    private String requestSn;

    /**
     * 同请求报文中的商户号
     * (选填)
     */
    private String custId;

    /**
     * 同请求报文中的交易码
     * (选填)
     */
    private String txCode;

    /**
     * 交易响应码
     * (选填)
     */
    private String returnCode;

    /**
     * 交易响应信息
     * (选填)
     */
    private String returnMsg;

    /**
     * 语言
     * (选填)
     */
    private String language;

    /**
     * 详情
     */
    private CcbRefundPageInfo txInfo;

    @Data
    public static class CcbRefundPageInfo {
        /**
         * 当前页次
         */
        private Integer curPage;
        /**
         * 总页次
         */
        private Integer tpage;
        /**
         * 提示信息
         */
        private String notice;
        /**
         * 流水明细
         */
        private List<CcbRefundQueryInfo> list;
    }

    @Data
    public static class CcbRefundQueryInfo {
        /**
         * 交易日期
         */
        private String tranDate;
        /**
         * 退款日期
         */
        private String refundDate;
        /**
         * 订单号
         */
        private String orderNumber;
        /**
         * 退款账号
         */
        private String refundAccount;
        /**
         * 支付金额
         */
        private BigDecimal payAmount;
        /**
         * 退款金额
         */
        private BigDecimal refundementAmount;
        /**
         * 柜台号
         */
        private String posCode;
        /**
         * 操作员
         */
        private String userid;
        /**
         * 订单状态，0:失败,1:成功,2:待银行确认,5:待银行确认
         */
        private String status;
        /**
         * 退款流水号，商户退款时上送的退款流水号，无上送则不展示
         */
        private String refundCode;
        /**
         * 备注1
         */
        private String rem1;
        /**
         * 备注2
         */
        private String rem2;
        /**
         * 支付方式，BHK:建行;THK:他行;ZFB:支付宝;CFT:微信
         */
        private String payMode;
        /**
         * 订单金额
         */
        private BigDecimal origAmt;
        /**
         * 退款结算金额
         */
        private BigDecimal txnClrgamt;
        /**
         * 退款手续费金额
         */
        private BigDecimal mrchcmsnAmt;
        /**
         * 银行流水号
         */
        private String oriovrlsttnevTrckNo;
        /**
         * 商户流水号
         */
        private String msgrpJrnlNo;
        /**
         * 卡属性位图
         */
        private String crdAttrBmpDefID;
        /**
         * 发卡行机构号
         */
        private String dstcrdIssubnkInsno;
        /**
         * 交易标志位图
         */
        private String onlnpcsgind1BmpEcd;
        /**
         * 交易金额
         */
        private BigDecimal txnamt;
        /**
         * 客户类型优惠描述
         */
        private String cstTpPrftDsc;
        /**
         * 流水类型代码
         */
        private String jrnlTpcd;
    }
}