/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.request.wlpt;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version CcbLargeFileDownloadRequest.java, v 0.1 2024-04-28 10:28 AM wangqilei
 */
@Data
public class CcbLargeFileDownloadRequest {
    /**
     * 要下载的文件名称，要下载的文件名，如：CBB1172476199728
     * (必填)
     */
    @NotBlank
    @Length(max = 128, message = "source长度不能超过128")
    private String source;

    /**
     * 文件路径，要下载文件的路径:merchant/shls，必须填该值
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "filepath长度不能超过30")
    private String filepath;

    /**
     * 下载路径标志，一般0
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "localRemote长度不能超过1")
    private String localRemote;
}