/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import cn.hutool.http.HttpRequest;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.CcbPayHttpResult;
import com.fshows.ccbpay.client.base.IHttpRequest;

import java.io.IOException;

/**
 * http请求实现类
 *
 * @author liluqing
 * @version DefaultHttpRequest.java, v 0.1 2022-03-02 18:19
 */
public class CcbJsapiHttpRequestImpl implements IHttpRequest {

    @Override
    public CcbPayHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws IOException {

        String req = url +"?"+requestBody;

        String resBody = HttpRequest.get(req)
                .timeout(apiClientConfig.getConnectionTimeout())
                .execute().body();
        CcbPayHttpResult ccbPayHttpResult = new CcbPayHttpResult();
        ccbPayHttpResult.setBody(resBody);
        return ccbPayHttpResult;
    }
}