/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.client.impl;

import ccb.pay.api.util.CCBPayUtil;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.ccbpay.annotation.NeedSign;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.LogUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcbPayApiSignerImpl<T extends CcbPayBaseRequest, R extends CcbPayBaseResponse>
implements ISigner<T, R> {
    private static final Logger log = LoggerFactory.getLogger(CcbPayApiSignerImpl.class);

    @Override
    public String sign(T request, ApiClientConfig apiClientConfig) throws CcbPayApiException {
        return null;
    }

    @Override
    public Boolean verifySign(R response, ApiClientConfig apiClientConfig) throws CcbPayApiException {
        try {
            String oriSignData = this.buildOriSignData(response);
            LogUtil.info(log, "\u3010ccbpay-sdk\u3011\u9a8c\u7b7e\u539f\u6587 >> sign={}", oriSignData);
            String pubKey = apiClientConfig.getCcbPayPublicKey();
            CCBPayUtil ccbPayUtil = new CCBPayUtil();
            boolean result = ccbPayUtil.verifyNotifySign(oriSignData, ((CcbPayBaseResponse)response).getSign(), pubKey);
            return result;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u5efa\u884c\u5f00\u653e\u5e73\u53f0\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> response={}", e, response);
            throw new CcbPayApiException("\u5efa\u884c\u5f00\u653e\u5e73\u53f0\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    private String buildOriSignData(R response) {
        Field[] fields = response.getClass().getDeclaredFields();
        ArrayList<Field> orderedFields = new ArrayList<Field>();
        for (Field field2 : fields) {
            NeedSign orderAnnotation = field2.getAnnotation(NeedSign.class);
            if (orderAnnotation == null) continue;
            orderedFields.add(field2);
        }
        orderedFields.sort(Comparator.comparingInt(field -> field.getAnnotation(NeedSign.class).value()));
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < orderedFields.size(); ++i) {
            Field field3 = (Field)orderedFields.get(i);
            try {
                field3.setAccessible(true);
                JSONField annotation = field3.getAnnotation(JSONField.class);
                if (i != 0) {
                    result.append("&");
                }
                result.append(annotation.name()).append("=").append(field3.get(response) == null ? "" : field3.get(response));
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return result.toString().trim();
    }
}

