/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import cn.hutool.core.util.StrUtil;
import com.ccb.wlpt.RequestProcess;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.CcbPayHttpResult;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.enums.wlpt.CcbWlptApiDefinitionEnum;

import java.io.IOException;

/**
 * http请求实现类
 *
 * @author liluqing
 * @version DefaultHttpRequest.java, v 0.1 2022-03-02 18:19
 */
public class WlptRequestImpl implements IHttpRequest {

    @Override
    public CcbPayHttpResult post(String url, String authorization, String requestBody, ApiClientConfig apiClientConfig) throws IOException {
        // 文件下载和请求Api不一样
        String resBody = requestBody.contains(CcbWlptApiDefinitionEnum.LARGE_FILE_DOWNLOAD.getTxCode()) ?
                RequestProcess.downloadFile(url, requestBody, apiClientConfig.getFilePath()) : RequestProcess.sendRequest(url, requestBody);
        CcbPayHttpResult ccbPayHttpResult = new CcbPayHttpResult();
        ccbPayHttpResult.setBody(resBody);
        return ccbPayHttpResult;
    }
}