/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.fshows.ccbpay.util.LogUtil;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcbPaySignUtils {
    private static final Logger log = LoggerFactory.getLogger(CcbPaySignUtils.class);
    private static final String PARAM_SIGNATURE = "signature";
    private static final String DEFAULT_ENCODE = "UTF-8";
    private static final String PROVIDER_BC = "BC";

    public static Map<String, String> sign(Map<String, String> params, String privateKeyStr) throws Exception {
        PrivateKey privateKey = CcbPaySignUtils.getPrivateKey(privateKeyStr);
        return CcbPaySignUtils.sign(params, privateKey, DEFAULT_ENCODE);
    }

    private static Map<String, String> sign(Map<String, String> params, PrivateKey privateKey, String encode) throws Exception {
        encode = StrUtil.isBlank((CharSequence)encode) ? DEFAULT_ENCODE : encode;
        params = CcbPaySignUtils.filterBlank(params);
        String stringData = CcbPaySignUtils.coverMap2String(params, true);
        LogUtil.info(log, "ccb pay activity sign params = {}", stringData);
        byte[] byteSign = null;
        String stringSign = null;
        byte[] signDigest = CcbPaySignUtils.sha256X16(stringData, encode);
        byteSign = org.apache.commons.codec.binary.Base64.encodeBase64((byte[])CcbPaySignUtils.signBySoft256(privateKey, signDigest));
        stringSign = new String(byteSign, encode);
        LogUtil.info(log, "ccb pay activity sign sign = {}", stringSign);
        params.put(PARAM_SIGNATURE, stringSign);
        return params;
    }

    private static Map<String, String> filterBlank(Map<String, String> content) {
        HashMap<String, String> submitFromData = new HashMap<String, String>();
        for (String key : content.keySet()) {
            String value = content.get(key);
            if (null == value || value.length() <= 0) continue;
            submitFromData.put(key, value.trim());
        }
        return submitFromData;
    }

    private static String coverMap2String(Map<String, String> params, boolean removeSignature) {
        if (MapUtil.isEmpty(params)) {
            return "";
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> en : params.entrySet()) {
            if (PARAM_SIGNATURE.equals(en.getKey()) && removeSignature) continue;
            treeMap.put(en.getKey(), en.getValue());
        }
        Iterator<Map.Entry<String, String>> it = treeMap.entrySet().iterator();
        StringBuilder sf = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry<String, String> en = it.next();
            sf.append(en.getKey()).append("=").append(en.getValue()).append("&");
        }
        return sf.substring(0, sf.length() - 1);
    }

    private static PrivateKey getPrivateKey(String privateKeyStr) throws InvalidKeySpecException, NoSuchAlgorithmException {
        byte[] priKeyBytes = Base64.getDecoder().decode(privateKeyStr);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(priKeyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    private static byte[] signBySoft256(PrivateKey privateKey, byte[] data) throws Exception {
        byte[] result = null;
        Signature st = Signature.getInstance("SHA256withRSA", PROVIDER_BC);
        st.initSign(privateKey);
        st.update(data);
        result = st.sign();
        return result;
    }

    private static byte[] sha256X16(String data, String encoding) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        byte[] bytes = CcbPaySignUtils.sha256(data.getBytes(encoding));
        StringBuilder sha256StrBuff = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String str = Integer.toHexString(0xFF & bytes[i]);
            if (str.length() == 1) {
                sha256StrBuff.append("0");
            }
            sha256StrBuff.append(str);
        }
        return sha256StrBuff.toString().getBytes(encoding);
    }

    private static byte[] sha256(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = null;
        md = MessageDigest.getInstance("SHA-256");
        md.reset();
        md.update(data);
        return md.digest();
    }

    static {
        if (Security.getProvider(PROVIDER_BC) == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        } else {
            Security.removeProvider(PROVIDER_BC);
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

