/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.client.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import com.alibaba.fastjson.JSONObject;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.CcbPaySignUtils;
import com.fshows.ccbpay.util.LogUtil;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignerImpl<T extends CcbPayBaseRequest, R extends CcbPayBaseResponse>
implements ISigner<T, R> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignerImpl.class);

    @Override
    public String sign(T request, ApiClientConfig apiClientConfig) throws CcbPayApiException {
        return this.doSign(request, apiClientConfig);
    }

    @Override
    public Boolean verifySign(R response, ApiClientConfig apiClientConfig) throws CcbPayApiException {
        try {
            String waitSignStr = this.getWaitSignStr(response);
            String signStr = ((CcbPayBaseResponse)response).getSign();
            Digester sha256 = new Digester(DigestAlgorithm.SHA256);
            String digestHex = sha256.digestHex(waitSignStr);
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)apiClientConfig.getFubeiPrivateKey()), SecureUtil.decode((String)apiClientConfig.getCcbPayPublicKey()));
            return sign.verify(digestHex.getBytes(apiClientConfig.getCharset()), Base64.decode((CharSequence)signStr));
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u5efa\u884c\u5f00\u653e\u5e73\u53f0\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> response={}", e, response);
            throw new CcbPayApiException("\u5efa\u884c\u5f00\u653e\u5e73\u53f0\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    public String doSign(T obj, ApiClientConfig apiClientConfig) throws CcbPayApiException {
        try {
            String waitSignStr = this.getWaitSignStr(obj);
            Map<String, String> params = this.objectToMap(obj);
            params = CcbPaySignUtils.sign(params, apiClientConfig.getFubeiPrivateKey());
            return params.get("signature");
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010ccbpay-sdk\u3011\u5efa\u884c\u5f00\u653e\u5e73\u53f0\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> obj={}", e, obj);
            throw new CcbPayApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }

    public String getWaitSignStr(Object obj) {
        Map paramMap = BeanUtil.beanToMap((Object)obj, (boolean)false, (boolean)true);
        paramMap.remove("signature");
        ArrayList keys = new ArrayList(paramMap.keySet());
        Collections.sort(keys);
        StringBuilder content = new StringBuilder();
        int index = 0;
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            Object value = paramMap.get(key);
            if (!StringUtils.isNotBlank((CharSequence)key) || value == null) continue;
            content.append((index == 0 ? "" : "&") + key + "=" + value);
            ++index;
        }
        return content.toString();
    }

    private Map<String, String> objectToMap(Object param) throws IllegalAccessException {
        HashMap map = Maps.newHashMap();
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Class<?> clazz = param.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] declaredFields = clazz.getDeclaredFields();
            fieldsList.addAll(Arrays.asList(declaredFields));
        }
        for (Field field : fieldsList) {
            String name;
            field.setAccessible(true);
            Object value = field.get(param);
            if (null == value || ObjectUtil.isNull((Object)value) || "serialVersionUID".equals(name = field.getName())) continue;
            if (this.simpleClass(field.getType())) {
                map.put(name, String.valueOf(value));
                continue;
            }
            map.put(name, JSONObject.toJSONString((Object)value));
        }
        return map;
    }

    private boolean simpleClass(Class<?> parameterType) {
        return parameterType == String.class || parameterType == Integer.class || parameterType == Integer.TYPE || parameterType == Double.class || parameterType == Double.TYPE || parameterType == Long.class || parameterType == Long.TYPE || parameterType == Float.class || parameterType == Float.TYPE || parameterType == Byte.class || parameterType == Byte.TYPE || parameterType == Boolean.class || parameterType == Boolean.TYPE || parameterType == BigDecimal.class;
    }
}

