/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.client.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.XML;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.client.impl.AbstractCcbPayApiClientImpl;
import com.fshows.ccbpay.client.impl.DefaultSignerImpl;
import com.fshows.ccbpay.client.impl.WlptRequestImpl;
import com.fshows.ccbpay.enums.wlpt.CcbWlptApiDefinitionEnum;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.request.base.CcbWlptCommonRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.CcbRequestUtils;
import com.fshows.ccbpay.util.LogUtil;
import com.fshows.ccbpay.util.ValidateUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcbWlptApiClientImpl
extends AbstractCcbPayApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(CcbWlptApiClientImpl.class);

    public CcbWlptApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        this(apiClientConfig, new WlptRequestImpl(), new DefaultSignerImpl());
    }

    public CcbWlptApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, null);
    }

    public CcbWlptApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest bizRequest, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        CcbWlptCommonRequest request = (CcbWlptCommonRequest)bizRequest;
        request.setTxCode(((CcbWlptApiDefinitionEnum)tradeApiDefinitionEnum).getTxCode());
        request.setCustId(this.apiClientConfig.getMainMerchantNumber());
        request.setUserId(this.apiClientConfig.getUserId());
        request.setPassword(this.apiClientConfig.getUserPwd());
        request.setLanguage(this.apiClientConfig.getLanguage());
        return request;
    }

    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        Map<String, String> requstMap = CcbRequestUtils.toMap(request);
        StringBuilder xmlBuilder = new StringBuilder();
        Map<String, String> detailMap = CcbRequestUtils.toMap(((CcbWlptCommonRequest)request).getTxInfo());
        for (Map.Entry<String, String> entry : detailMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            xmlBuilder.append("<").append(key).append(">").append(value).append("</").append(key).append(">");
        }
        requstMap.put("TX_INFO", xmlBuilder.toString());
        this.apiClientConfig.setFilePath(request.getFileUrl());
        return CcbRequestUtils.generateXml(requstMap);
    }

    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        try {
            JSONObject txRes = XML.toJSONObject((String)resBody);
            return (CcbPayBaseResponse)com.alibaba.fastjson.JSONObject.parseObject((String)txRes.get((Object)"TX").toString(), tradeApiDefinitionEnum.getResponseClass());
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010ccb-sdk\u3011\u54cd\u5e94\u7ed3\u679c\u53cd\u5e8f\u5217\u5316\u5f02\u5e38 >> resBody={}", e, resBody);
            return null;
        }
    }

    @Override
    protected void checkParam(CcbPayBaseRequest bizRequest, ICcbPayApiDefinition apiDefinition) throws CcbPayApiException {
        ValidateUtil.notNull(bizRequest, "request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        System.out.println();
        CcbWlptCommonRequest request = (CcbWlptCommonRequest)bizRequest;
        boolean checkRequestClass = StringUtils.equals((CharSequence)request.getTxInfo().getClass().getCanonicalName(), (CharSequence)apiDefinition.getRequestClass().getCanonicalName());
        if (!checkRequestClass) {
            throw new CcbPayApiException("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.apiClientConfig.isCheckParam()) {
            ValidateUtil.validateWithThrow(bizRequest, new Class[0]);
        }
    }

    @Override
    protected String getServerURL(ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return this.apiClientConfig.getApiParentURL();
    }
}

