/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ccbpay.client.impl;

import ccb.pay.api.util.CCBPayUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.client.impl.AbstractCcbPayApiClientImpl;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcbPayApiClientImpl
extends AbstractCcbPayApiClientImpl {
    private static final Logger log = LoggerFactory.getLogger(CcbPayApiClientImpl.class);

    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        super(apiClientConfig);
    }

    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return request;
    }

    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException {
        StringBuilder merInfo = new StringBuilder();
        merInfo.append("MERCHANTID=").append(request.getMerchantid()).append("&");
        merInfo.append("POSID=").append(request.getPosid()).append("&");
        merInfo.append("BRANCHID=").append(request.getBranchid());
        String ccbParamText = merInfo.toString().concat(this.getWaitSignStr(request));
        log.info("\u3010ccbpay-sdk\u3011\u751f\u6210ccbParam,\u539f\u6587 >> param = {}", (Object)ccbParamText);
        CCBPayUtil ccbPayUtil = new CCBPayUtil();
        String ccbParam = null;
        try {
            ccbParam = ccbPayUtil.makeCCBParam(ccbParamText, this.apiClientConfig.getCcbPayPublicKey());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        StringBuilder merInfoMore = merInfo.append("&GROUPMCH=JTSH:").append(this.apiClientConfig.getMainMerchantNumber()).append(this.apiClientConfig.getCounterNumber()).append(this.apiClientConfig.getBranchNumber());
        String body = merInfoMore.append("&ccbParam=").append(ccbParam).toString();
        log.info("\u3010ccbpay-sdk\u3011 \u751f\u6210\u62a5\u6587\u8bf7\u6c42\u4f53 >> body  = {}", (Object)body);
        return body;
    }

    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return (CcbPayBaseResponse)JSONObject.parseObject((String)resBody, tradeApiDefinitionEnum.getResponseClass());
    }

    private String getWaitSignStr(CcbPayBaseRequest request) {
        Field[] fields;
        StringBuilder ccbParam = new StringBuilder();
        for (Field field : fields = request.getClass().getDeclaredFields()) {
            JSONField annotation = field.getAnnotation(JSONField.class);
            if (annotation == null) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(request);
                ccbParam.append("&").append(annotation.name()).append("=").append(value == null ? "" : value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return ccbParam.toString();
    }
}

