/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.ccbpay.response.trade.order;

import com.fshows.ccbpay.annotation.NeedSign;
import com.fshows.ccbpay.response.base.CcbNormalPayBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.Length;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * 订单查询接口
 *
 * @author
 * @version CcbWlOrderQueryResponse.java, v 0.1 2022-07-05 10:41:07
 */
@Data
public class CcbOrderQueryResponse extends CcbNormalPayBizResponse implements Serializable {

    private static final long serialVersionUID = -2213838555903266941L;

    /**
     * 订单结果
     * Y：成功N：失败U：不确定（交易超时，建议通过订单查询确认扣款结果）Q：待轮询（需按照[3.2.3.支付及轮询流程说明]继续调用轮询接口查询订单结果）其他无法明确订单结果的情况，均继续调用轮询接口查询
     *
     * 示例：Y
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "result长度不能超过1")
    @JSONField(name = "RESULT")
    @NeedSign(1)
    private String result;

    /**
     * 订单号
     * 从请求参数中获得
     *
     * 示例：20180906101102
     * (特殊必填)
     */
    @Length(max = 30, message = "orderid长度不能超过30")
    @JSONField(name = "ORDERID")
    @NeedSign(2)
    private String orderid;

    /**
     * 订单金额
     * 从请求参数中获得
     *
     * 示例：5
     * (特殊必填)
     */
    @Length(max = 16, message = "amount长度不能超过16")
    @JSONField(name = "AMOUNT")
    @NeedSign(3)
    private String amount;


    /**
     * 等待时间
     * RESULT为Q（待轮询）时返回，单位:秒建议商户按返回等待相应时间后再发起轮询
     *
     * 示例：5
     * (特殊必填)
     */
    @Length(max = 2, message = "waittime长度不能超过2")
    @JSONField(name = "WAITTIME")
    @NeedSign(4)
    private String waittime;

    /**
     * 全局事件跟踪号
     * 建行交易流水号
     *
     * 示例：1010113861527649530264100
     * (特殊必填)
     */
    @Length(max = 30, message = "traceid长度不能超过30")
    @JSONField(name = "TRACEID")
    private String traceid;

    /**
     * 客户实付金额
     */
    @JSONField(name = "PAID_AMOUNT")
    private String paidAmount;

    /**
     * 商户实收金额
     */
    @JSONField(name = "RECEIPT_AMOUNT")
    private String receiptAmount;

    /**
     * 优惠活动名
     */
    @JSONField(name = "COUPONARRAY")
    private String couponArray;

    /**
     * 支付详情
     */
    @JSONField(name = "PAYMENT_DETAILS")
    private String paymentDetails;

    /**
     * 微信优惠金
     */
    @JSONField(name = "COUPONAMOUNT_WX")
    private String couponAmountWx;

    /**
     * 微信优惠卷详情
     */
    @JSONField(name = "promotion_detail")
    private String promotionDetail;

    /**
     * 支付宝优惠金额
     */
    @JSONField(name = "COUPONAMOUNT_ALI")
    private String couponAmountAli;

    /**
     * 支付宝单品卷信息
     */
    @JSONField(name = "discount_goods_detail")
    private String discountGoodDetail;


    /**
     * 支付宝所有优惠卷信息
     */
    @JSONField(name = "voucher_detail_list")
    private String voucherDetailList;


    /**
     * 错误码
     * 报错时返回
     *
     * 示例：ZBLAP101WX01
     * (特殊必填)
     */
    @Length(max = 12, message = "errcode长度不能超过12")
    @JSONField(name = "ERRCODE")
    private String errcode;

    /**
     * 错误信息
     * 报错时返回
     *
     * 示例：支付不成功，@@ORDERNOTEXIST~~order not exist@@
     * (特殊必填)
     */
    @Length(max = 80, message = "errmsg长度不能超过80")
    @JSONField(name = "ERRMSG")
    private String errmsg;

    /**
     * 签名
     * 签名串，签名源文格式见下方说明，验签方法详见[4.2.返回报文验签方法]
     *
     * 示例：20924b4c8018c591c62d05fffaa32c0009613050c2b739002b0228e74
     * (特殊必填)
     */
    @Length(max = 200, message = "sign长度不能超过200")
    @JSONField(name = "SIGN")
    private String sign;

}