/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.response.base;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;

/**
 * 全局响应公共参数基类
 *
 * @author liluqing
 * @version CcbPayBaseResponse.java, v 0.1 2022-03-02 11:27
 */
@Data
public abstract class CcbPayBaseResponse implements Serializable {

    private static final long serialVersionUID = 1063737463083778025L;

    /**
     * 应答码
     */
    @JSONField(name = "ERRCODE")
    private String errCode;

    /**
     * 响应信息
     */
    @JSONField(name = "ERRMSG")
    private String errMsg;


    /**
     * 签名
     * 签名串，签名源文格式见下方说明，验签方法详见[4.2.返回报文验签方法]
     *
     * 示例：20924b4c8018c591c62d05fffaa32c0009613050c2b739002b0228e74
     * (特殊必填)
     */
    @Length(max = 200, message = "sign长度不能超过200")
    @JSONField(name = "SIGN")
    private String sign;


    /**
     * 获取原始签名值
     * @return {@link String}
     */
    protected String getOriSignData() {
        return null;
    }

}