/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.request.wlpt;

import com.fshows.ccbpay.annotation.CcbFieldName;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version CcbOrderRefundDetailRequest.java, v 0.1 2024-04-26 3:23 PM wangqilei
 */
@Data
public class CcbRefundRequest {

    /**
     * 退款金额，CN
     * (选填)
     */
    @Length(max = 100, message = "money长度不能超过100")
    private String money;

    /**
     * 订单号，CN
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "order长度不能超过30")
    private String order;

    /**
     * 可不填，商户自动生成的退款流水号
     * (选填)
     */
    @Length(max = 15, message = "refundCode长度不能超过15")
    private String refundCode;

    /**
     * 退款商户号
     * (选填)
     */
    @CcbFieldName("Mrch_No")
    @Length(max = 15, message = "mrchNo长度不能超过15")
    private String mrchNo;

    /**
     * (选填)
     */
    @Length(max = 254, message = "signInfo长度不能超过254")
    private String signInfo;

    /**
     * 客户采用socket连接时，建行客户端自动添加
     * (选填)
     */
    @Length(max = 254, message = "signCert长度不能超过254")
    private String signcert;
}