/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.response.wlpt;

import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author wangqilei
 * @version CcbWlOrderQueryResponse.java, v 0.1 2024-05-08 9:38 AM wangqilei
 */
@Data
public class CcbWlOrderQueryResponse extends CcbPayBaseResponse {
    private static final long serialVersionUID = 6037830076213324804L;

    /**
     * 同请求报文中的序列号
     * (选填)
     */
    private String requestSn;

    /**
     * 同请求报文中的商户号
     * (选填)
     */
    private String custId;

    /**
     * 同请求报文中的交易码
     * (选填)
     */
    private String txCode;

    /**
     * 交易响应码
     * (选填)
     */
    private String returnCode;

    /**
     * 交易响应信息
     * (选填)
     */
    private String returnMsg;

    /**
     * 语言
     * (选填)
     */
    private String language;

    /**
     * 明细
     */
    private CcbOrderPageInfo txInfo;


    @Data
    public static class CcbOrderPageInfo {
        /**
         * 当前页次
         */
        private Integer curPage;
        /**
         * 总页次
         */
        private Integer pageCount;
        /**
         * 提示信息
         */
        private String notice;
        /**
         * 流水明细
         */
        private List<CcbOrderQueryInfo> list;
    }

    @Data
    public static class CcbOrderQueryInfo {
        /**
         * 交易日期
         */
        private String transDate;
        /**
         * 记账日期
         */
        private String accDate;
        /**
         * 订单号
         */
        private String order;
        /**
         * 付款方账号
         */
        private String account;
        /**
         * 付款方姓名
         */
        private String accName;
        /**
         * 支付金额
         */
        private BigDecimal paymentMoney;
        /**
         * 退款金额
         */
        private BigDecimal refundMoney;
        /**
         * 柜台号
         */
        private String posId;
        /**
         * 备注1
         */
        private String rem1;
        /**
         * 备注2
         */
        private String rem2;

        /**
         * 订单状态
         */
        private String orderStatus;
        /**
         * 支付方式
         */
        private String payMode;
        /**
         * 订单金额
         */
        private BigDecimal origAmt;
        /**
         * 结算金额
         */
        private BigDecimal txnClrgamt;
        /**
         * 手续费金额
         */
        private BigDecimal mrchcmsnAmt;
        /**
         * 优惠金额
         */
        private BigDecimal discountAmt;
        /**
         * 银行流水
         */
        private String oriovrlsttnevTrckNo;
        /**
         * 商户流水
         */
        private String msgrpJrnlNo;
        /**
         * 信用卡分期数
         */
        private String crcrdInstmPrdNum;
        /**
         * 卡属性位图
         */
        private String crdAttrBmpDefID;
        /**
         * 发卡行机构号
         */
        private String dstcrdIssubnkInsno;
        /**
         * 交易标志位图
         */
        private String onlnpcsgind1BmpEcd;
        /**
         * 交易金额
         */
        private BigDecimal txnamt;
        /**
         * 客户类型优惠描述
         */
        private String cstTpPrftDsc;
        /**
         * 流水类型代码
         */
        private String jrnlTpcd;
    }
}

