/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.request.wlpt;

import com.fshows.ccbpay.annotation.CcbFieldName;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * @author wangqilei
 * @version CcbWlOrderQueryRequest.java, v 0.1 2024-05-08 9:23 AM wangqilei
 */
@Data
public class CcbWlOrderQueryRequest {

    /**
     * 起始日期，格式YYYYMMDD
     * (选填)
     */
    @Length(max = 8, message = "start长度不能超过8")
    private String start;

    /**
     * 开始小时
     * (选填)
     */
    @Length(max = 2, message = "starthour长度不能超过2")
    private String starthour;

    /**
     * 开始分钟
     * (选填)
     */
    @Length(max = 2, message = "startmin长度不能超过2")
    private String startmin;

    /**
     * 截止日期，格式YYYYMMDD
     * (选填)
     */
    @Length(max = 8, message = "end长度不能超过8")
    private String end;

    /**
     * 结束小时
     * (选填)
     */
    @Length(max = 2, message = "endhour长度不能超过2")
    private String endhour;

    /**
     * 结束分钟
     * (选填)
     */
    @Length(max = 2, message = "endmin长度不能超过2")
    private String endmin;

    /**
     * 流水状态，1：已结流水（默认），0：未结流水
     * （POS商户送1）
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "kind长度不能超过1")
    private String kind;

    /**
     * 订单号，（KIND为0时有效）
     * (选填)
     */
    @Length(max = 30, message = "order长度不能超过30")
    private String order;

    /**
     * 结算账户号，暂不用
     * (选填)
     */
    @Length(max = 30, message = "account长度不能超过30")
    private String account;

    /**
     * 文件类型，默认为“1”，1:不压缩,2.压缩成zip文件
     * (必填)
     */
    @Length(max = 1, message = "dexcel长度不能超过1")
    private String dexcel;

    /**
     * 金额，不支持以金额查询
     * (必填)
     */
    @Length(max = 18, message = "money长度不能超过18")
    private BigDecimal money;

    /**
     * 排序方式，1：交易日期，2：订单号（KIND为0时有效）
     * (选填)
     */
    @Length(max = 1, message = "norderby长度不能超过1")
    private String norderby;

    /**
     * 当前页次
     * (选填)
     */
    @Length(max = 10, message = "norderby长度不能超过10")
    private Integer page;

    /**
     * 柜台号，不输入为全部 （KIND为0时有效）
     * (选填)
     */
    @Length(max = 9, message = "posCode长度不能超过9")
    private String posCode;

    /**
     * 订单状态，0：交易失败，1：交易成功，2：待银行确认（未结流水），3：全部（未结流水）（KIND为0时有效且非空）
     * (选填)
     */
    @Length(max = 1, message = "status长度不能超过1")
    private String status;

    /**
     * 子商户号（集团商户查询子商户流水时有效，支持'all'全下载）
     * (选填)
     */
    @CcbFieldName("Mrch_No")
    @Length(max = 32, message = "mrchNo长度不能超过32")
    private String mrchNo;

    /**
     * 融合标志，默认下载人民币流水，1-表示下载融合流水（人民币+数币）（KIND为0时有效）
     * (选填)
     */
    @Length(max = 1, message = "txnTpcd长度不能超过1")
    private String txnTpcd;
}