/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.ccbpay.request.trade.order;

import com.fshows.ccbpay.enums.trade.CcbPayTradeApiDefinitionEnum;
import com.fshows.ccbpay.response.trade.order.CcbOrderQueryResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

import org.hibernate.validator.constraints.Length;
import com.alibaba.fastjson.annotation.JSONField;

import com.fshows.ccbpay.request.base.CcbPayBizRequest;

/**
 *
 *
 * @author
 * @version CcbWlOrderQueryRequest.java, v 0.1 2022-07-05 10:41:07
 */
@Data
public class CcbOrderQueryRequest extends CcbPayBizRequest<CcbOrderQueryResponse, CcbPayTradeApiDefinitionEnum> {

    private static final long serialVersionUID = -2213838555881740475L;



    /**
     * 交易码
     * 固定值PAY102
     *
     * 示例：PAY102
     * (必填)
     */
    @NotBlank
    @Length(max = 6, message = "txcode长度不能超过6")
    @JSONField(name = "TXCODE")
    private String txcode;

    /**
     * 商户类型
     * 1：线上商户2：线下商户商户类型请与分行确认
     *
     * 示例：1
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "merflag长度不能超过1")
    @JSONField(name = "MERFLAG")
    private String merflag;

    /**
     * 终端编号1
     * 商户类型为2时上送请联系开立商户的分行提供
     *
     * 示例：1054210970800090001
     * (特殊必填)
     */
    @Length(max = 19, message = "termno1长度不能超过19")
    @JSONField(name = "TERMNO1")
    private String termno1;

    /**
     * 终端编号2
     * 商户类型为2时上送请联系开立商户的分行提供
     *
     * 示例：12345678
     * (特殊必填)
     */
    @Length(max = 8, message = "termno2长度不能超过8")
    @JSONField(name = "TERMNO2")
    private String termno2;

    /**
     * 订单号
     * 订单标识
     *
     * 示例：20180906101102
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "orderid长度不能超过30")
    @JSONField(name = "ORDERID")
    private String orderid;

    /**
     * 二维码类型
     * 2：微信3：支付宝
     *
     * 示例：2
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "qrcodetype长度不能超过2")
    @JSONField(name = "QRCODETYPE")
    private String qrcodetype;


    /**
     * 查询次数
     */
    @NotBlank
    @JSONField(name = "QRYTIME")
    private String qryTime;

    /**
     * 返回位图
     */
    @NotBlank
    @JSONField(name = "RETURN_FIELD")
    private String returnField;

}