/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.request.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import java.io.Serializable;
import java.util.Map;

/**
 * 建行开放平台全局请求参数总父类
 *
 * @author liluqing
 * @version CcbPayBaseRequest.java, v 0.1 2022-03-02 11:20
 */
@Data
public class CcbPayBaseRequest<T extends CcbPayBaseResponse, E extends ICcbPayApiDefinition>  implements Serializable {

    private static final long serialVersionUID = 7549242518235178596L;

    /**
     * 商户号
     * 请联系开立商户的分行提供
     *
     * 示例：105421097080009
     * (必填)
     */
    @Length(max = 15, message = "merchantid长度不能超过15")
    @JSONField(name = "MERCHANTID")
    private String merchantid;

    /**
     * 柜台号
     * 请联系开立商户的分行提供
     *
     * 示例：902807340
     * (必填)
     */
    @Length(max = 9, message = "posid长度不能超过9")
    @JSONField(name = "POSID")
    private String posid;

    /**
     * 分行号
     * 请联系开立商户的分行提供（一级分行号）
     *
     * 示例：360000000
     * (必填)
     */
    @Length(max = 9, message = "branchid长度不能超过9")
    @JSONField(name = "BRANCHID")
    private String branchid;

    /**
     * 集团商户信息
     * （非集团商户无需上送）集团主商户代理发起子商户交易时（验证主商户柜台公钥），需将集团主商户信息填入该字段，格式为：JTSH:主商户号+主商户柜台+主商户分行号例如：JTSH:105000000000000123456789441000000其中：105000000000000为主商户号，123456789为主商户柜台号，441000000为主商户一级分行号
     *
     * 示例：JTSH:105000000000000123456789441000000
     * (特殊必填)
     */
    @Length(max = 40, message = "groupmch长度不能超过40")
    @JSONField(name = "GROUPMCH")
    private String groupmch;

    /**
     * 加密串
     * 加密串通过[4.2.请求报文加密方法]中的说明生成，加密源串参数包含以下浅蓝色底纹的参数，如：TXCODE=PAY100&amp;MERFLAG=1&amp;ORDERID=20180906101102&amp;QRCODE=134737690209713402&amp;AMOUNT=0.01
     *
     * 示例：ylQZnF9G57gKymsjC99NTUyqUwynqgeCywvYhT%2FhW1%2CFRewTw4t0nEk8Jz%2FKYI%0AY6Pa7rQPRMJ6nmkqO7B
     * (必填)
     */
    @Length(max = 6144, message = "ccbparam长度不能超过6144")
    @JSONField(name = "ccbParam")
    private String ccbparam;


    /**
     * 公钥
     */
    private String pub;


    /**
     * 微信、支付宝主扫需mac字段
     * @return {@link Map}<{@link String}, {@link String}>
     */
    public Map<String, String> getReqMap() {
        return null;
    }
}