/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import ccb.pay.api.util.CCBPayUtil;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.request.base.CcbPayBizRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Map;


/**
 * 建行开放平台交易接口客户端
 *
 * @author liluqing
 * @version UnionPayApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
@Slf4j
public class CcbPayApiClientImpl extends AbstractCcbPayApiClientImpl {


    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        super(apiClientConfig);
    }

    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }


    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {

        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    /**
     * 添加对入参进行额外处理
     *
     * @param request 业务请求参数
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return request;
    }
    /**
     * 接口参数序列化
     *
     * @param request
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException {

        StringBuilder merInfo = new StringBuilder();
        // 商户信息
        merInfo.append("MERCHANTID=").append(request.getMerchantid()).append("&");
        merInfo.append("POSID=").append(request.getPosid()).append("&");
        merInfo.append("BRANCHID=").append(request.getBranchid());

        // 获取ccbParam原文
        String ccbParamText = merInfo.toString().concat(getWaitSignStr(request));
        log.info("【ccbpay-sdk】 生成ccbParam,原文 >> param = {}",ccbParamText.toString());

        //执行加密操作
        CCBPayUtil ccbPayUtil = new CCBPayUtil();
        String ccbParam = null;
        try {
            ccbParam = ccbPayUtil.makeCCBParam(ccbParamText, apiClientConfig.getCcbPayPublicKey());

        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        // 集团信息
        StringBuilder merInfoMore = merInfo.append("&GROUPMCH=JTSH:").append(apiClientConfig.getMainMerchantNumber()).append(apiClientConfig.getCounterNumber()).append(apiClientConfig.getBranchNumber());

        String body =  merInfoMore.append("&ccbParam=").append(ccbParam).toString();
        log.info("【ccbpay-sdk】 生成报文请求体 >> body  = {}", body);
        return body;

        /*// CcbPayBizRequest tradeRequest = BeanUtil.copyProperties(request,CcbPayBizRequest.class);
        // 商户信息组装
        StringBuilder body = new StringBuilder();
        body.append("MERCHANTID=").append(request.getMerchantid()).append("&");
        body.append("POSID=").append(request.getPosid()).append("&");
        body.append("BRANCHID=").append(request.getBranchid()).append("&");
        body.append("GROUPMCH=JTSH:").append(apiClientConfig.getMainMerchantNumber()).
                append(apiClientConfig.getCounterNumber()).
                append(apiClientConfig.getBranchNumber());

        // ccbParam
        String param = request.getCcbParam();
        //String param = "TXCODE=PAY100&MERFLAG=1&ORDERID=20180906101102&QRCODE=134737690209713402&AMOUNT=0.01";
        LogUtil.info(log, "【ccbpay-sdk】生成ccbParam,原文 >>param = {}", param);
        CCBPayUtil ccbPayUtil = new CCBPayUtil();
        try {
            String ccbParam = ccbPayUtil.makeCCBParam(param, apiClientConfig.getCcbPayPublicKey());
            body.append("&ccbParam=").append(ccbParam);
            return body.toString();
        } catch (UnsupportedEncodingException e) {
            LogUtil.error(log, "【ccbpay-sdk】生成ccbParam失败 >> url={}, param = {}", tradeApiDefinitionEnum.getApiSubURI(), param);
            throw new CcbPayApiException("【ccbpay-sdk】生成ccbParam失败");
        }*/

        // 支付demo
        //String merInfo = "MERCHANTID=105009658121466&POSID=081098131&BRANCHID=330000000" ;
        /*String merInfoMore = merInfo +"&GROUPMCH=JTSH:"+ apiClientConfig.getMainMerchantNumber() +apiClientConfig.getCounterNumber()+ apiClientConfig.getBranchNumber();
        String param = merInfo + "&MERFLAG=1&TERMNO1=&TERMNO2=&ORDERID=202400018scan" +
                "&QRCODE=285393137888747952&AMOUNT=0.01&TXCODE=PAY100&PROINFO=&REMARK1=&REMARK2=&SMERID=&SMERNAME=&SMERTYPEID=" +
                "&SMERTYPE=&TRADECODE=&TRADENAME==&detail=&goods_detail_ali=";
        //执行加密操作
        CCBPayUtil ccbPayUtil = new CCBPayUtil();
        String url = null;
        try {
            url = ccbPayUtil.makeCCBParam(param, apiClientConfig.getCcbPayPublicKey());

        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        String body =  merInfoMore + "&ccbParam=" + url;
        return body;*/

        // 查询demo
        /*String merInfo = "MERCHANTID=105009658121466&POSID=081098131&BRANCHID=330000000" ;
                String merInfoMore = merInfo +"&GROUPMCH=JTSH:"+ apiClientConfig.getMainMerchantNumber() +apiClientConfig.getCounterNumber()+ apiClientConfig.getBranchNumber();
        String param = merInfo + "&MERFLAG=1&TERMNO1=&TERMNO2=&ORDERID=202400015scan&QRYTIME=1" +
                "&QRCODETYPE=3&TXCODE=PAY101&REMARK1=&REMARK2=&RETURN_FIELD=11111100000000000000&SUB_APPID=";
        //执行加密操作
        CCBPayUtil ccbPayUtil = new CCBPayUtil();
        String url = null;
        try {
            url = ccbPayUtil.makeCCBParam(param, apiClientConfig.getCcbPayPublicKey());

        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        String body =  merInfoMore + "&ccbParam=" + url;
        return body;
*/




/*
        StringBuilder body = new StringBuilder();
        body.append("MERCHANTID=").append(request.getMerchantid()).append("&");
        body.append("POSID=").append(request.getPosid()).append("&");
        body.append("BRANCHID=").append(request.getBranchid()).append("&");
        body.append("GROUPMCH=JTSH:").append(apiClientConfig.getMainMerchantNumber()).
                append(apiClientConfig.getCounterNumber()).
                append(apiClientConfig.getBranchNumber());

        body.append("&ccbParam=").append(reqParams.get("ccbParam"));
        return body.toString();*/

    }

    /**
     * 响应结果反序列化
     *
     * @param resBody
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return (CcbPayBaseResponse) JSONObject.parseObject(resBody, tradeApiDefinitionEnum.getResponseClass());
    }


    /**
     * 获取待加签字符串
     * @param request
     * @return {@link String}
     */
    private String getWaitSignStr(CcbPayBaseRequest request) {

        StringBuilder ccbParam = new StringBuilder();

        Field[] fields = request.getClass().getDeclaredFields();
        for (Field field : fields) {
            JSONField annotation = field.getAnnotation(JSONField.class);
            if (annotation != null) {
                field.setAccessible(true);
                try {
                    Object value = field.get(request);

                    ccbParam.append("&").append(annotation.name()).append("=").append(value == null ? "" : value);
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        return ccbParam.toString();
    }
}