/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.ccbpay.client.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import com.alibaba.fastjson.JSONObject;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.CcbPayHttpResult;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.request.base.CcbPayJsApiBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import com.fshows.ccbpay.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

/**
 * @author liubo
 * @version CcbJsapiPayApiClientImp.java, v 0.1 2024-04-29-6:02 下午 liubo
 */
@Slf4j
public class CcbJsapiPayApiClientImp extends AbstractCcbPayApiClientImpl{


    public CcbJsapiPayApiClientImp(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return doExecute(request, tradeApiDefinitionEnum);
    }

    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {

        request.setPub(apiClientConfig.getCcbPayPublicKey().substring(apiClientConfig.getCcbPayPublicKey().length() - 30));
        return request;
    }

    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException, IOException {


        StringBuilder requestValue = new StringBuilder();
        requestValue.append("CCB_IBSVersion=V6&");
        // 获取请求value
        Map reqMap = request.getReqMap();

        // 生成mac值
        String reqValue = buildReq(reqMap, apiClientConfig.getCharset());
        Digester md5 = new Digester(DigestAlgorithm.MD5);
        // md5 加密
        String mac = md5.digestHex(reqValue).toLowerCase();

        // 获取requestBody
        requestValue.append(reqValue.replaceAll("&PUB=" + apiClientConfig.getCcbPayPublicKey().substring(apiClientConfig.getCcbPayPublicKey().length() - 30), ""));
        // 额外参数

        //requestValue.append("&RETURN_FIELD=").append("10010000000000000000");
        // 拼接mac值
        requestValue.append("&MAC=").append(mac);
        return requestValue.toString();
    }

    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return (CcbPayBaseResponse) JSONObject.parseObject(resBody, tradeApiDefinitionEnum.getResponseClass());
    }

    /**
     * 执行建行开放平台请求
     *
     * @param bizRequest
     * @param tradeApiDefinitionEnum
     * @return
     * @throws CcbPayApiException
     *//*
    @Override
    protected <R extends CcbPayBaseResponse, E extends ICcbPayApiDefinition> R doExecute(CcbPayBaseRequest<R, E> bizRequest, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException {
        try {
            // 参数校验
            checkParam(bizRequest, tradeApiDefinitionEnum);
            // 补全全局公共参数
            CcbPayBaseRequest ccbpayBaseRequest = buildBizRequest(bizRequest, tradeApiDefinitionEnum);
            // 序列化请求参数
            String body = serializableRequest(ccbpayBaseRequest, tradeApiDefinitionEnum);
            // 执行加签操作获取签名
            String url = getServerURL(tradeApiDefinitionEnum);
            // 执行HTTP post请求
            CcbPayHttpResult httpResult = requestPost(url, null, body);
            // 反序列化响应参数
            CcbPayBaseResponse response = parseResponse(httpResult.getBody(), tradeApiDefinitionEnum);
            // 根据是否验签配置判断是否需要验签
            if (this.apiClientConfig.isVrifySignResponse()) {
                boolean bo = signer.verifySign(response, this.apiClientConfig);
                if (!bo) {
                    LogUtil.error(log, "【ccbpay-sdk】响应结果验签失败 >> httpResult={}", httpResult);
                    throw new CcbPayApiException("[ccbpay-sdk]响应结果验签失败");
                }
            }
            // 反序列化响应参数
            return (R) response;
        } catch (CcbPayApiException e) {
            LogUtil.error(log, "【ccbpay-sdk】建行开放平台请求异常 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw e;
        } catch (Exception e) {
            LogUtil.error(log, "【ccbpay-sdk】建行开放平台请求异常 >> tradeApiDefinition={}, bizRequest={}", e, tradeApiDefinitionEnum, bizRequest);
            throw new CcbPayApiException(e.getMessage(), e);
        }
    }
*/
    /**
     * @param params
     * @param charset
     * @return {@link String}
     * @throws IOException
     */
    public static String buildReq(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();

        boolean isFirst = true;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!isFirst) {
                query.append("&");
            } else {
                isFirst = false;
            }
            //query.append(name).append("=").append(StrUtil.isNotEmpty(value) ? URLEncoder.encode(value, charset) : "");
            if (name.equals("proInfo")) {
                query.append(name).append("=").append(StrUtil.isNotEmpty(value) ? URLEncoder.encode(value, charset) : "");
            } else {
                query.append(name).append("=").append(value);

            }
        }

        return query.toString();
    }
}