/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.request.settle;

import com.fshows.ccbpay.annotation.CcbFieldName;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version CcbStatmentFileRequest.java, v 0.1 2024-04-28 10:10 AM wangqilei
 */
@Data
public class CcbStatmentFileRequest {
    /**
     * 查询的日期，格式YYYYMMDD
     * (必填)
     */
    @NotBlank
    @Length(max = 8, message = "date长度不能超过8")
    private String date;

    /**
     * 流水状态，1：已结流水（默认），0：未结流水
     * （POS商户送1）
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "kind长度不能超过1")
    private String kind;

    /**
     * 文件类型，1：txt（默认），2：excel，3：txt+excel
     * （POS商户、龙商户送1；网络特约商户可送1/2/3，
     * 对账单下载时间在3秒内为实时返回账单文件名，超过3秒转为异步下载，
     * 具体请参考应答报文RETURN_CODE字段说明处理）
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "fileType长度不能超过1")
    private String fileType;

    /**
     * 流水类型，0：支付流水；1：退款流水 （KIND为0时有效且非空）
     * (选填)
     */
    @Length(max = 1, message = "type长度不能超过1")
    private String type;

    /**
     * 排序方式，1：交易日期，2：订单号（KIND为0时有效）
     * (选填)
     */
    @Length(max = 1, message = "norderby长度不能超过1")
    private String norderby;

    /**
     * 柜台号，不输入为全部 （KIND为0时有效）
     * (选填)
     */
    @Length(max = 9, message = "posCode长度不能超过9")
    private String posCode;

    /**
     * 订单号，（KIND为0时有效）
     * (选填)
     */
    @Length(max = 30, message = "order长度不能超过30")
    private String order;

    /**
     * 订单状态，0：交易失败，1：交易成功，2：待银行确认（未结流水），3：全部（未结流水）（KIND为0时有效且非空）
     * (选填)
     */
    @Length(max = 1, message = "status长度不能超过1")
    private String status;

    /**
     * 对账单标志，0-旧，1-新（KIND为0时有效）
     * (选填)
     */
    @Length(max = 1, message = "billFlag长度不能超过1")
    private String billFlag;

    /**
     * 子商户号（集团商户查询子商户流水时有效，支持'all'全下载）
     * (选填)
     */
    @CcbFieldName("Mrch_No")
    @Length(max = 32, message = "mrchNo长度不能超过32")
    private String mrchNo;

    /**
     * 集团账单汇总标志，0-打包对账单，1-汇总对账单，2-打包+汇总对账单（网络特约商户且KIND为1、Mrch_No为'all'时有效)
     * (选填)
     */
    @Length(max = 1, message = "groupFlag长度不能超过1")
    private String groupFlag;

    /**
     * 融合标志，默认下载人民币流水，1-表示下载融合流水（人民币+数币）（KIND为0时有效）
     * (选填)
     */
    @Length(max = 1, message = "txnTpcd长度不能超过1")
    private String txnTpcd;
}