/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.ccbpay.client.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.request.base.CcbPayJsApiBaseRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.extern.slf4j.Slf4j;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;

/**
 * @author liubo
 * @version CcbJsapiPayApiClientImp.java, v 0.1 2024-04-29-6:02 下午 liubo
 */
@Slf4j
public class CcbJsapiPayApiClientImp extends AbstractCcbPayApiClientImpl{


    public CcbJsapiPayApiClientImp(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBaseRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return null;
    }

    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {

        CcbPayJsApiBaseRequest req = BeanUtil.copyProperties(request,CcbPayJsApiBaseRequest.class);
        req.setPub(apiClientConfig.getCcbPayPublicKey());
        return req;
    }

    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) throws CcbPayApiException, IOException {

        CcbPayJsApiBaseRequest req = BeanUtil.copyProperties(request,CcbPayJsApiBaseRequest.class);

        StringBuilder requestValue = new StringBuilder();
        requestValue.append("CCB_IBSVersion=V6");
        // 获取请求value
        Map reqMap = req.getReqMap();

        // 生成mac值
        String reqValue = buildReq(reqMap, apiClientConfig.getCharset());
        Digester md5 = new Digester(DigestAlgorithm.MD5);
        // md5 加密
        String mac = md5.digestHex(reqValue);

        // 获取requestBody
        requestValue.append(reqValue.replaceAll("&PUB=" + apiClientConfig.getCcbPayPublicKey().substring(apiClientConfig.getCcbPayPublicKey().length() - 30), ""));
        // 额外参数
        requestValue.append("&RETURN_FIELD=").append("10010000000000000000");
        // 拼接mac值
        requestValue.append("&MAC=").append(mac);
        return requestValue.toString();
    }

    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return null;
    }

    /**
     * @param params
     * @param charset
     * @return {@link String}
     * @throws IOException
     */
    public static String buildReq(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();

        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            query.append("&");
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }

        return query.toString();
    }
}