/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved
 */
package com.fshows.ccbpay.response.trade.pay;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author liubo
 * @version CcbWxJsApiPayResponse.java, v 0.1 2024-04-23-11:37 上午 liubo
 */
public class CcbWxJsApiPayResponse extends CcbPayBaseResponse implements Serializable {

    private static final long serialVersionUID = 2975383552427415920L;

    /**
     * 订单结果是否成功
     * success 成功
     *
     */
    @NotBlank
    @Length(max = 10, message = "success长度不能超过10")
    @JSONField(name = "SUCCESS")
    private String success;

    /**
     * 交易链接（用于获取微信支付信息）
     *
     */
    @NotBlank
    @Length(max = 500, message = "PAYURL长度不能超过500")
    @JSONField(name = "PAYURL")
    private String payurl;


}