/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.ccbpay.response.trade.order;

import com.fshows.ccbpay.response.base.CcbPayBaseResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.Length;
import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;

/**
 * 订单查询接口
 *
 * @author
 * @version CcbOrderQueryResponse.java, v 0.1 2022-07-05 10:41:07
 */
@Data
public class CcbOrderQueryResponse  extends CcbPayBaseResponse implements Serializable {

    private static final long serialVersionUID = -2213838555903266941L;


    /**
     * 订单结果
     * Y：成功N：失败U：不确定（交易超时，建议再次查询）Q：待查询（交易正在进行中，如等待客户付款）
     *
     * 示例：Y
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "result长度不能超过1")
    @JSONField(name = "RESULT")
    private String result;

    /**
     * 订单号
     * 从请求参数中获得
     *
     * 示例：20180906101102
     * (特殊必填)
     */
    @Length(max = 30, message = "orderid长度不能超过30")
    @JSONField(name = "ORDERID")
    private String orderid;

    /**
     * 订单金额
     * 该笔订单的资金总额
     *
     * 示例：0.01
     * (特殊必填)
     */
    @Length(max = 16, message = "amount长度不能超过16")
    @JSONField(name = "AMOUNT")
    private String amount;

    /**
     * 支付宝交易号
     * 支付宝交易号
     *
     * 示例：2018090422001427221001018215
     * (特殊必填)
     */
    @Length(max = 64, message = "zfbNo长度不能超过64")
    @JSONField(name = "ZFB_NO")
    private String zfbNo;

    /**
     * 支付宝交易状态
     * 交易状态：WAIT_BUYER_PAY（交易创建，等待买家付款）TRADE_CLOSED（未付款交易超时关闭，或支付完成后全额退款）TRADE_SUCCESS（交易支付成功）TRADE_FINISHED（交易结束，不可退款）
     *
     * 示例：TRADE_SUCCESS
     * (特殊必填)
     */
    @Length(max = 32, message = "zfbState长度不能超过32")
    @JSONField(name = "ZFB_STATE")
    private String zfbState;

    /**
     * 微信支付订单号
     * 微信支付订单号
     *
     * 示例：4200000160201809050255683083
     * (特殊必填)
     */
    @Length(max = 32, message = "wechatNo长度不能超过32")
    @JSONField(name = "WECHAT_NO")
    private String wechatNo;

    /**
     * 微信交易状态
     * SUCCESS—支付成功
     * REFUND—转入退款
     * NOTPAY—未支付
     * CLOSED—已关闭
     * REVOKED—已撤销（刷卡支付）
     * USERPAYING--用户支付中
     * PAYERROR--支付失败（其他原因，如银行返回失败）
     *
     * 示例：SUCCESS
     * (特殊必填)
     */
    @Length(max = 32, message = "wechatState长度不能超过32")
    @JSONField(name = "WECHAT_STATE")
    private String wechatState;

    /**
     * 错误码
     * 报错时返回
     *
     * 示例：ZBLAP101WX01
     * (特殊必填)
     */
    @Length(max = 12, message = "errcode长度不能超过12")
    @JSONField(name = "ERRCODE")
    private String errcode;

    /**
     * 错误信息
     * 报错时返回
     *
     * 示例：支付不成功，@@ORDERNOTEXIST~~order not exist@@
     * (特殊必填)
     */
    @Length(max = 80, message = "errmsg长度不能超过80")
    @JSONField(name = "ERRMSG")
    private String errmsg;

    /**
     * 签名
     * 签名串，签名源文格式见下方说明，验签方法详见[4.2.返回报文验签方法]
     *
     * 示例：20924b4c8018c591c62d05fffaa32c0009613050c2b739002b0228e74
     * (特殊必填)
     */
    @Length(max = 200, message = "sign长度不能超过200")
    @JSONField(name = "SIGN")
    private String sign;

}