package com.fshows.ccbpay.enums.trade;

import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.enums.base.CcbApiTypeEnum;
import com.fshows.ccbpay.request.trade.order.CcbOrderCloseRequest;
import com.fshows.ccbpay.request.trade.order.CcbOrderQueryRequest;
import com.fshows.ccbpay.request.trade.order.CcbQueryOrderStatusRequest;
import com.fshows.ccbpay.request.trade.pay.CcbScanCardPayRequest;
import com.fshows.ccbpay.response.trade.order.CcbOrderCloseResponse;
import com.fshows.ccbpay.response.trade.order.CcbOrderQueryResponse;
import com.fshows.ccbpay.response.trade.order.CcbQueryOrderStatusResponse;
import com.fshows.ccbpay.response.trade.pay.CcbScanCardPayResponse;

/**
 * 建行开放平台交易相关API
 *
 * @author liluqing
 * @version CcbPayTradeApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum CcbPayTradeApiDefinitionEnum implements ICcbPayApiDefinition {
    PRE_ORDER_CREATE(
            "主扫交易（统一下单接口）",
            "530590",
            null,
            null,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    SCAN_CARD_CREATE(
            "被扫交易（付款码支付）",
            "PAY100",
            CcbScanCardPayRequest.class,
            CcbScanCardPayResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    ORDER_QUERY(
            "订单查询接口",
            "PAY102",
            CcbOrderQueryRequest.class,
            CcbOrderQueryResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    QUERY_ORDER_STATUS(
            "订单状态轮询接口",
            "PAY101",
            CcbQueryOrderStatusRequest.class,
            CcbQueryOrderStatusResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    REFUND_CREATE(
            "退款申请发起",
            "",
            null,
            null,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    REFUND_QUERY(
            "退款查询",
            "",
            null,
            null,
            CcbApiTypeEnum.OUT_CONNECT_PLATFORM
    ),
    ORDER_CLOSE(
            "关单交易",
            "PAY103",
            CcbOrderCloseRequest.class,
            CcbOrderCloseResponse.class,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    WX_JS_API_PAY(
            "微信公众号交易",
            "530590",
            null,
            null,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    ALIPAY_JS_API_PAY(
            "支付宝扫码交易",
            "530550",
            null,
            null,
            CcbApiTypeEnum.DIRECT_CONNECT
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    /**
     * API类型
     */
    private CcbApiTypeEnum ccbApiTypeEnum;


    CcbPayTradeApiDefinitionEnum(String name,
                                 String apiSubURI,
                                 Class requestClass,
                                 Class responseClass,
                                 CcbApiTypeEnum ccbApiTypeEnum) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
        this.ccbApiTypeEnum =  ccbApiTypeEnum;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}