/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.impl;

import com.alibaba.fastjson.JSONObject;
import com.fshows.ccbpay.client.base.ApiClientConfig;
import com.fshows.ccbpay.client.base.IHttpRequest;
import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;
import com.fshows.ccbpay.client.base.ISigner;
import com.fshows.ccbpay.exception.CcbPayApiException;
import com.fshows.ccbpay.request.base.CcbPayBaseRequest;
import com.fshows.ccbpay.request.base.CcbPayBizRequest;
import com.fshows.ccbpay.response.base.CcbPayBaseResponse;


/**
 * 建行开放平台交易接口客户端
 *
 * @author liluqing
 * @version UnionPayApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
public class CcbPayApiClientImpl extends AbstractCcbPayApiClientImpl {


    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig) throws CcbPayApiException {
        super(apiClientConfig);
    }

    public CcbPayApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws CcbPayApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends CcbPayBaseResponse, R extends ICcbPayApiDefinition> T execute(CcbPayBizRequest<T, R> request, R tradeApiDefinitionEnum) throws CcbPayApiException {
        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    /**
     * 添加对入参进行额外处理
     *
     * @param bizRequest 业务请求参数
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseRequest buildBizRequest(CcbPayBizRequest bizRequest, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return bizRequest;
    }

    /**
     * 接口参数序列化
     *
     * @param request
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected String serializableRequest(CcbPayBaseRequest request, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return JSONObject.toJSONString(request);
    }

    /**
     * 响应结果反序列化
     *
     * @param resBody
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected CcbPayBaseResponse parseResponse(String resBody, ICcbPayApiDefinition tradeApiDefinitionEnum) {
        return (CcbPayBaseResponse) JSONObject.parseObject(resBody, tradeApiDefinitionEnum.getResponseClass());
    }
}