/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.base;

import com.fshows.ccbpay.constant.CommonConstant;
import com.fshows.ccbpay.enums.base.SignTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 客户端配置信息model
 *
 * @author liluqing
 * @version ClientMetaInfoModel.java, v 0.1 2022-03-01 20:37
 */
@Data
public class ApiClientConfig {

    /**
     * 网关根URL
     */
    @NotBlank(message = "建行开放平台网关地址不能为空")
    protected String apiParentURL;

    /**
     * 用于加签的付呗私钥
     */
    @NotBlank(message = "建行开放平台SDK加签付呗私钥不能为空")
    protected String fubeiPrivateKey;

    /**
     * 用于验签的建行开放平台公钥
     */
    protected String ccbPayPublicKey;

    /**
     * 加签算法类型
     */
    protected SignTypeEnum signTypeEnum = SignTypeEnum.RSA2;

    /**
     * 是否对建行开放平台响应结果进行验签
     */
    protected boolean vrifySignResponse = true;

    /**
     * 是否对参数进行前置校验
     */
    protected boolean checkParam = true;

    /**
     * http连接超时时间
     */
    protected int connectionTimeout = CommonConstant.DEFAULT_CONNECTION_TIMEOUT;

    /**
     * http response读取超时时间
     */
    protected int readTimeout = CommonConstant.DEFAULT_READ_TIMEOUT;

    /**
     * 默认编码格式，默认为utf-8
     */
    protected String charset = CommonConstant.UTF_8;

}