package com.fshows.ccbpay.enums.settle;

import com.fshows.ccbpay.client.base.ICcbPayApiDefinition;

/**
 * 建行开放平台结算相关API
 *
 * @author liluqing
 * @version CcbPaySettleApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum CcbPaySettleApiDefinitionEnum implements ICcbPayApiDefinition {

    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    CcbPaySettleApiDefinitionEnum(String name,
                                  String apiSubURI,
                                  Class requestClass,
                                  Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}