/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.ccbpay.client.base;

import com.fshows.ccbpay.enums.merchant.CcbPayMerchantApiDefinitionEnum;
import com.fshows.ccbpay.enums.settle.CcbPaySettleApiDefinitionEnum;
import com.fshows.ccbpay.enums.trade.CcbPayTradeApiDefinitionEnum;

/**
 * 建行开放平台API资源定义
 * <p>
 * 目前API资源采用enum方式定义
 *
 * @author liluqing
 * @version ICcbPayApiDefinition.java, v 0.1 2022-03-01 20:24
 * @see CcbPayTradeApiDefinitionEnum
 * @see CcbPayMerchantApiDefinitionEnum
 * @see CcbPaySettleApiDefinitionEnum
 */
public interface ICcbPayApiDefinition {

    /**
     * 获取url资源子路径
     * 例如: 接口的URL是 “https://partner.95516.com/gateway”
     * ,则ApiSubPath则是域名后的部分内容“/api/merchantModify”
     */
    String getApiSubURI();

    /**
     * 获取requestClass
     *
     * @return
     */
    Class getRequestClass();

    /**
     * 获取responseClass
     *
     * @return
     */
    Class getResponseClass();
}