/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.response.trade.order;

import lombok.Data;

/**
 * @author wangqilei
 * @version CcbOrdeRefundResponse.java, v 0.1 2024-04-25 11:37 AM wangqilei
 */
@Data
public class CcbOrderRefundResponse {

    /**
     * 订单号
     * (选填)
     */
    private String orderNum;

    /**
     * 订单金额
     * (选填)
     */
    private String payAmount;

    /**
     * 退款金额
     * (选填)
     */
    private String amount;

    /**
     * 退款方式，ZFB:支付宝;CFT:微信;其他返回空
     * (选填)
     */
    private String payMode;

    /**
     * 申请退款总金额，PAY_MODE=ZFB或CFT时有效，否则返回空值
     * (选填)
     */
    private String refundFee;

    /**
     * 商户实际退款金额，PAY_MODE=ZFB或CFT时有效，否则返回空值
     * (选填)
     */
    private String mrchAccentramt;

    /**
     * 买家退款金额，PAY_MODE=ZFB或CFT时有效，否则返回空值
     * (选填)
     */
    private String cashRefundFee;

    /**
     * 代金券退款，PAY_MODE=CFT时有效，否则返回空值
     * (选填)
     */
    private String couponRefundFee;

    /**
     * 平台优惠退款金额，PAY_MODE=ZFB时有效，否则返回空值
     * (选填)
     */
    private String presentRefundDiscount;

    /**
     * 商家优惠退款金额，PAY_MODE=ZFB时有效，否则返回空值
     * (选填)
     */
    private String presentRefundMdiscountAmount;

    /**
     * 交易金额，折后金额，龙支付优惠退货时返回实际退卡金额
     * (选填)
     */
    private String txnamt;

    /**
     * 联机处理标志一位图编码，龙支付优惠退货时返回权益位图编码
     * (选填)
     */
    private String onlnpcsgind1BmpEcd;
}