/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.response.trade.order;

import lombok.Data;

import java.math.BigDecimal;

/**
 * @author wangqilei
 * @version CcbOrderRefundQueryResponse.java, v 0.1 2024-04-28 11:07 AM wangqilei
 */
@Data
public class CcbOrderRefundQueryDetailResponse {
    /**
     * 交易日期
     */
    private String tranDate;
    /**
     * 退款日期
     */
    private String refundDate;
    /**
     * 订单号
     */
    private String orderNumber;
    /**
     * 退款账号
     */
    private String refundAccount;
    /**
     * 支付金额
     */
    private BigDecimal payAmount;
    /**
     * 退款金额
     */
    private BigDecimal refundementAmount;
    /**
     * 柜台号
     */
    private String posCode;
    /**
     * 操作员
     */
    private String userid;
    /**
     * 订单状态，0:失败,1:成功,2:待银行确认,5:待银行确认
     */
    private String status;
    /**
     * 退款流水号，商户退款时上送的退款流水号，无上送则不展示
     */
    private String refundCode;
    /**
     * 备注1
     */
    private String rem1;
    /**
     * 备注2
     */
    private String rem2;
    /**
     * 支付方式，BHK:建行;THK:他行;ZFB:支付宝;CFT:微信
     */
    private String payMode;
    /**
     * 订单金额
     */
    private BigDecimal OrigAmt;
    /**
     * 退款结算金额
     */
    private BigDecimal TxnClrgAmt;
    /**
     * 退款手续费金额
     */
    private BigDecimal MrchCmsnAmt;
    /**
     * 银行流水号
     */
    private String OriOvrlsttnEVTrckNo;
    /**
     * 商户流水号
     */
    private String MsgRpJrnlNo;
    /**
     * 卡属性位图
     */
    private String CrdAttrBmpDefID;
    /**
     * 发卡行机构号
     */
    private String DstCrdIssuBnkInsNo;
    /**
     * 交易标志位图
     */
    private String OnlnPcsgInd1BmpECD;
    /**
     * 交易金额
     */
    private BigDecimal TxnAmt;
    /**
     * 客户类型优惠描述
     */
    private String CstTpPrftDsc;
    /**
     * 流水类型代码
     */
    private String JrnlTpCd;
}