/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.ccbpay.response.base;

import lombok.Data;

/**
 * @author wangqilei
 * @version CcbPayCommonResponse.java, v 0.1 2024-04-26 3:38 PM wangqilei
 */
@Data
public class CcbPayCommonResponse<T> extends CcbPayBaseResponse {

    private static final long serialVersionUID = -3903846936402741795L;

    /**
     * 同请求报文中的序列号
     * (选填)
     */
    private String requestSn;

    /**
     * 同请求报文中的商户号
     * (选填)
     */
    private String custId;

    /**
     * 同请求报文中的交易码
     * (选填)
     */
    private String txCode;

    /**
     * 交易响应码
     * (选填)
     */
    private String returnCode;

    /**
     * 交易响应信息
     * (选填)
     */
    private String returnMsg;

    /**
     * 语言
     * (选填)
     */
    private String language;

    /**
     * 详情
     */
    private T txInfo;
}