package com.fshows.ccbpay.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 建行开放平台交易API响应码枚举
 *
 * @author liluqing
 * @version CcbPayResponseCodeEnum.java, v 0.1 2022-03-02 11:04 liluqing
 */
public enum CcbPayResponseCodeEnum {
    SUCCESS("成功", "00")
    ;

    private String name;
    private String value;

    CcbPayResponseCodeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static CcbPayResponseCodeEnum getByValue(String value) {
        CcbPayResponseCodeEnum[] valueList = CcbPayResponseCodeEnum.values();
        for (CcbPayResponseCodeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}